/*
 *  File: SG_SockUtils.h
 *  Project: ShmanssyGUI
 *
 *  Written by: Ivan Leben
 *  Licence: GNU GPL
 *
 */

#ifndef SOCKUTILS_H
#define SOCKUTILS_H

#if defined(WIN32)
	#include <winsock.h>
	#define socklen_t int
#else
	#include <netdb.h>
	#include <sys/types.h>
	#include <sys/socket.h>
	#include <netinet/in.h>
	#include <arpa/inet.h>
	#include <ctype.h>
#endif

#define ERR_HOST -1
#define ERR_SOCKET -2
#define ERR_BIND -3
#define ERR_LISTEN -4
#define ERR_CONNECT -5
#define ERR_SEND -6
#define ERR_RECIEVE -7
#define ERR_MOREDATA -8

class Connection
{
public:
	void *server; //backward pointer to server holding this connection
	
	char ip[20];
	int socket;
	sockaddr_in address;
	
	bool waitForData;
	int recv_bytes;
	char *buffer;
	
	Connection();
	~Connection();
};

class SG_SockServer
{
public:
	//sockets and addresses
	int listen_socket;
	struct sockaddr_in my_addr;

	//accepting connections;
	bool waitForConnections;
	void (*OnAccept)(int clientID);
	LinkedList connections;

	//recieving
	void (*OnRecieve)(int clientID, char *data, int size);

	//general functions
	SG_SockServer();
	~SG_SockServer();

	void GetIP(char **chIP);
	SG_String GetClientIP(int clientID);
	Connection* FindClientByID(int clientID);
	
	int Listen(char *bind_ip, short port, int max_connections);
	void Stop();

	int StartRecieve(int clientID, int bytes_per_call);
	int Send(int clientID, void *buf, int bytes, int *bytes_sent);
	int SendToAll(void *buf, int bytes, int *bytes_sent);
};

class SG_SockClient
{
public:
       //sockets and addresses
       int server_socket;

       //recieving
	   bool waitForData;
       int recv_bytes;
       char *buffer;
       void (*OnRecieve)(char *data, int size);

       //general functions
       SG_SockClient();
       ~SG_SockClient();

       int Connect(char *hostname, short port);
       int Send(void *buf, int bytes, int *bytes_sent);
       int StartRecieve(int bytes_per_call);
};

int AcceptConnThread(void* pParam);
int ServerRecvThread(void *param);
int ClientRecvThread(void *param);

char *GetSockErrDesc(int ErrNo);

#endif