/*
 *  File: SG_String.h
 *  Project: ShmanssyGUI
 * 
 *  Written by: Ivan Leben
 *  Licence: GNU GPL
 *
 */

#ifndef SG_STRING_H
#define SG_STRING_H
 
#include <stdarg.h>

typedef unsigned short int UNICODE;
int strlenUNI(UNICODE *txt);
void strcpyUNI(UNICODE *txtDst, UNICODE *txtSrc);

class SG_String
{
public:
	char *conversionText;
	UNICODE *buffer;
	
	SG_String();
	SG_String(const char *txt);
	SG_String(const SG_String &str);
	~SG_String();

	operator char*();
	operator char**();
	SG_String& operator= (const char *txt);
	SG_String& operator= (const SG_String &str);
	SG_String& operator+= (const char *txt);	
	SG_String& operator+= (const SG_String &str);
	SG_String& operator+= (const UNICODE code);
	SG_String operator+ (const char *txt);
	SG_String operator+ (const SG_String &str);
	SG_String operator+ (const UNICODE code);

	UNICODE* Buffer() {return buffer;}	
	UNICODE operator[] (int i) {return buffer[i];}	
	int Length() {return strlenUNI(buffer);}
		
	int ToInt();
	void Format(char *format, ...);
	void Format(char *format, va_list ap);
	
	SG_String Sub(int start, int length=-1);
};

#endif
