/*
 *  File: SG_Window.h
 *  Project: ShmanssyGUI
 *
 *  Written by: Ivan Leben
 *  Licence: GNU GPL
 *
 */

#ifndef SG_WINDOW_H
#define SG_WINDOW_H

#define SG_STANDARD 0
#define SG_BITMAP 1

class SG_Window
{
protected:
	SG_Rect bounds;
	SG_Rect localBounds;
	SG_Rect insideBounds;
	SG_Rect visibleBounds;

	SG_String text;
	SG_Cursor *cursor;
	SG_Font *font;
	int mouseState;
	int mouseFocus;
	bool has_focus;
	bool visible;
	bool enabled;
	bool timer_running;
	int timer_update;
	int timer_interval;
	
	SG_Window *parent;
	SG_Layout *layout;	

	SG_Graphics graphics;
	bool needsRedraw;
	float levelOfTransparency;
	bool childrenTransparent;
	int style;
	int border;
	SG_Color textColor;
	SG_Color backColor;
	SG_Bitmap *bitmap;
		
public:
	SG_Bitmap pixelBuffer;
	
	SG_Window();
	~SG_Window();

	//General
	//--------
	bool IsVisible();
	bool IsEnabled() {return enabled;}	
	SG_Rect& GlobalBounds();
	SG_Rect& LocalBounds();
	SG_Rect& InsideBounds();
	int Left() {return localBounds.x;}
	int Top() {return localBounds.y;}
	int Width() {return localBounds.w;}
	int Height() {return localBounds.h;}
	int Right() {return localBounds.Right();}
	int Bottom() {return localBounds.Bottom();}
	int MouseState() {return mouseState;}
	int MouseFocus() {return mouseFocus;}
	void SetFocus();
	bool HasFocus() {return has_focus;}
	void BringToFront();
	void LocalToGlobal(SG_Point *pt);
	void LocalToGlobal(SG_Rect *rc);	
	void GlobalToLocal(SG_Point *pt);
	void GlobalToLocal(SG_Rect *rc);
	virtual void Resize(int w, int h);
	virtual void Move(int x, int y);
	virtual void SetBounds(SG_Rect &rect);	
	virtual void SetBounds(int x, int y, int w, int h);
	virtual void ApplyBounds(int x, int y, int w, int h);
	virtual bool ContainsRect(SG_Rect *rect);
	virtual bool ContainsPt(int x, int y);
	virtual void Show(bool is_visible);
	virtual void SetText(char *new_text);
	SG_String Text() {return text;}
	void SetCursor(SG_Cursor *newCursor) {cursor = newCursor;}
	SG_Cursor* Cursor() {return cursor;}
	virtual void SetFont(SG_Font *aFont) {font = aFont; Redraw();}
	SG_Font* Font() {return font;}
	void StartTimer(int interval);	
	void StopTimer();

	//Parenting
	//----------
	LinkedList children;
	SG_Window* Parent() {return parent;}	
	void SetParent(SG_Window *wndParent, bool addIntoLayout=true);
	bool IsChildOf(SG_Window *wnd);
	void SetLayout(SG_Layout *newLayout);
	SG_Layout* Layout() {return layout;}

	//Graphics
	//---------
/*	void SetLevelOfTransparency(float level, bool applyToChildren);
	float GetLevelOfTransparency();*/
	SG_Graphics* Graphics();
	void SetWindowStyle(int windowStyle);
	int WindowStyle() {return style;}
	void SetBorder(int borderType) {border = borderType;}
	int Border() {return border;}
	void SetTextColor(BYTE r, BYTE g, BYTE b, BYTE a=255) {textColor.FromRGBA(r,g,b,a);}
	void SetTextColor(SG_Color &color) {textColor = color;}
	SG_Color TextColor() {return textColor;}
	void SetBackColor(BYTE r, BYTE g, BYTE b, BYTE a=255) {backColor.FromRGBA(r,g,b,a);}
	void SetBackColor(SG_Color &color) {backColor = color;}
	SG_Color BackColor() {return backColor;}
	void SetBitmap(SG_Bitmap *aBitmap) {bitmap = aBitmap;}
	SG_Bitmap* Bitmap() {return bitmap;}
	virtual void Draw(SG_Graphics *gfx);
	void InvalidateWndRect();
	void Redraw();
	bool NeedsRedraw() {return needsRedraw;}	
	virtual void Blit(SDL_Surface *srfDst, SG_Rect &rcDst);

	//Event handlers
	//---------------
	virtual void Timer(int time);
	virtual void GotFocus();
	virtual void LostFocus();
	virtual void Enable(bool enable);
	virtual void MouseDown(int x, int y);
	virtual void MouseUp(int x, int y);
	virtual void MouseMove(int x, int y);
	virtual void MouseEnter();	
	virtual void MouseLeave();
	virtual void KeyDown(int key);
	virtual void KeyUp(int key);

	//Callbacks
	//----------
	SG_Window *wnd_callback;
	void (*OnBoundsChanged) (SG_Window*);
	void (*OnDraw) (SG_Graphics *gfx, SG_Window*);
	void (*OnTimer) (int, SG_Window*);
	void (*OnMouseDown) (int, int, SG_Window*);
	void (*OnMouseUp) (int, int, SG_Window*);
	void (*OnMouseMove) (int, int, SG_Window*);
	void (*OnMouseEnter) (SG_Window*);	
	void (*OnMouseLeave) (SG_Window*);
	void (*OnGotFocus) (SG_Window*);
	void (*OnLostFocus) (SG_Window*);
};

#endif
