/*
 *  File: portable.h
 *  Project: ShmanssyGUI
 *
 *  Written by: Ivan Leben
 *  Licence: GNU GPL
 *
 */

#ifndef PORTABLE_H
#define PORTABLE_H

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#define LIL_ENDIAN 1234
#define BIG_ENDIAN 4321

#if  defined(__i386__) || \
	 defined(__ia64__) || \
	 defined(WIN32) || \
	(defined(__alpha__) || defined(__alpha)) || \
	 defined(__arm__) || \
	(defined(__mips__) && defined(__MIPSEL__)) || \
     defined(__SYMBIAN32__) || \
	 defined(__x86_64__) || \
     defined(__LITTLE_ENDIAN__)
	 
	#define BYTE_ORDER	LIL_ENDIAN 
#else
	#define BYTE_ORDER	BIG_ENDIAN
#endif

//portability functions
typedef unsigned char BYTE;
void freadLE(void *buf, int size, FILE *file);
void freadBE(void *buf, int size, FILE *file);
void fwriteLE(void *buf, int size, FILE *file);
void fwriteBE(void *buf, int size, FILE *file);

void InvertBits(BYTE *b);
void freadBitsBE(BYTE *buf, int size, FILE *file);
void freadBitsLE(BYTE *buf, int size, FILE *file);

void memcpyLE(void *dst, void *src, int size);
void memcpyBE(void *dst, void *src, int size);

#endif
