#!/bin/bash


# TEMPLATE slackbuild script for XXXX
# Author: Mark Tucker
# Created: Jul 29, 2004
# Changes:
#        Jul 29, 2004 - initial creation
#

#
#----------------------------------------------------------------------
umask 0022
#----------------------------------------
# Package variables
#----------------------------------------
source="tramp-2.0.48.tar.gz"
pkgname="tramp"
pkgver="2.0.48"
release="1mht"
package="$pkgname-$pkgver-i486-$release.tgz"
slackver=`cat /etc/slackware-version`
echo Package: $package

#----------------------------------------
# setup path variables
#----------------------------------------
# where the source archive is located
srcdir=`pwd`/SRC
thisfile=`pwd`/`basename $0`
# get working directory
workdir=`dirname $0`
if [ "$workdir" == "." ]; then
    workdir=`pwd`/$pkgname
    if [ ! -d $workdir ]; then
	echo Creating working directory $workdir ...
	mkdir -p $workdir
    fi
    echo Working directory is $workdir
    cd $workdir
    echo Changed directory to  `pwd`
fi
builddir=$workdir/$pkgname-$pkgver


# unpack the source
echo Unpacking the source...
tar -xzf $srcdir/$source



cd $builddir

#----------------------------------------
# setup the build environment
#----------------------------------------
export CFLAGS="-O2 -march=i486 -mcpu=i686"
export CPPFLAGS="-O2 -march=i486 -mcpu=i686"
export CXXFLAGS=$CPPFLAGS

#----------------------------------------
# configure 
#----------------------------------------
echo Running configure...
./configure --prefix=/usr \
    --sysconfdir=/etc \
    --localstatedir=/var \
    --with-contrib \
    --with-emacs \
    > $workdir/config.output 2>&1

if [ $? -ne 0 ]; then
    echo There was a problem with the build process.
    echo check the contents of $workdir/config.output
    echo Exiting...
    exit
fi

#----------------------------------------
# make
#----------------------------------------
echo Running make...
make > $workdir/make.output 2>&1
if [ $? -ne 0 ]; then
    echo There was a problem with the build process.
    echo check the contents of $workdir/make.output
    echo Exiting...
    exit
fi

#----------------------------------------
# Set target directory
#----------------------------------------
target=$workdir/target
if [ ! -d $target ]; then
    mkdir $target
fi

#----------------------------------------
# install
#----------------------------------------
echo Installing to $target ...

# install lisp files...
mkdir -p $target/usr/share/emacs/site-lisp/

for i in trampver.el tramp.el tramp-smb.el tramp-util.el tramp-uu.el tramp-vc.el trampcache.el tramp-ftp.el password.el  trampver.elc tramp.elc tramp-smb.elc tramp-util.elc tramp-uu.elc tramp-vc.elc trampcache.elc tramp-ftp.elc password.elc 
do
  cp $builddir/lisp/$i $target/usr/share/emacs/site-lisp/
done

# install info files.
mkdir -p $target/usr/info
cp $builddir/info/tramp $target/usr/info/tramp.info
gzip  $target/usr/info/tramp.info


echo finishing install...


# create install dir
mkdir $target/install

# create do-inst.sh script
cat > $target/install/doinst.sh << END
#!/bin/sh

# Add the new info file to the info dir
install-info /usr/info/tramp.info.gz /usr/info/dir
#
END



#----------------------------------------
# create slack-desc file to install
#----------------------------------------
cat > $target/install/slack-desc << END
     |-----handy-ruler------------------------------------------------------|
$pkgname: $pkgname $pkgver Tramp, Transparent Remote Access, Multiple Protocol 
$pkgname:
$pkgname: This package provides remote file editing, similar to Ange-FTP.
$pkgname: The difference is that Ange-FTP uses FTP to transfer files between 
$pkgname: the local and the remote host, whereas TRAMP uses a combination of 
$pkgname: rsh and rcp or other work-alike programs, such as ssh/scp.
$pkgname:
$pkgname: http://www.freesoftware.fsf.org/tramp/
$pkgname:
$pkgname:
$pkgname: Packaged by Mark Tucker for $slackver
END

#----------------------------------------
# create documentation directory
#----------------------------------------
mkdir -p $target/usr/doc/$pkgname-$pkgver
cp $builddir/[A-Z]* $target/usr/doc/$pkgname-$pkgver/
chmod a+r $target/usr/doc/$pkgname-$pkgver/*
cp $thisfile $target/usr/doc/$pkgname-$pkgver/SlackPkg.sh

#----------------------------------------
# fix group on bin directories.
#----------------------------------------
for i in bin sbin usr/sbin usr/bin usr/X11R6/bin
do
  if [ -d $target/$i ]; then
      echo Changing group on $target/$i
      chgrp -R bin $target/$i
  fi
done

#----------------------------------------
# check for uncompressed man pages
#----------------------------------------
for i in usr/man opt/kde/man usr/share/man usr/X11R6/man
do
  if [ -d $target/$i ]; then
      find $target/$i -name \*.[0-9] -exec gzip {} \;
  fi
done

# makepkg
cd $target
echo Creating package...
makepkg  -c n -l y $workdir/$package 

cd $workdir
echo DONE
exit

