#!/bin/sh
config() {
  NEW="$1"
  OLD="`dirname $NEW`/`basename $NEW .new`"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "`cat $OLD | md5sum`" = "`cat $NEW | md5sum`" ]; then # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}

config etc/ntpd.conf.new
config etc/rc.d/rc.ntpd.new

# No need to keep this, just preserving permissions of rc.ntpd:
rm -f etc/rc.d/rc.ntpd.new

# If the ntp user/group don't exist, add them:
if grep "^ntp:x:" etc/passwd 1> /dev/null 2> /dev/null ; then
  true
else
  echo "ntp:x:38:38:ntp:/:/bin/false" >> etc/passwd
fi
if grep "^ntp::" etc/group 1> /dev/null 2> /dev/null ; then
  true
else
  echo "ntp::38:ntp" >> etc/group
fi
if grep "^ntp:" etc/shadow 1> /dev/null 2> /dev/null ; then
  true
else
  echo "ntp:*:9797:0:::::" >> etc/shadow
fi
