config() {
  NEW="$1"
  OLD="`dirname $NEW`/`basename $NEW .new`"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "`cat $OLD | md5sum`" = "`cat $NEW | md5sum`" ]; then # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}
config etc/lpd.conf.new
config etc/lpd.perms.new
config etc/rc.d/rc.lprng.new

# Fix permissions.  The spool directories have to be owned by lp.lp,
# and spool areas used by samba might need to be chmod 1777 (not done here)
if [ -d var/spool/lpd ]; then
  chown -R lp.lp var/spool/lpd
fi
( cd usr/bin ; rm -rf lpq )
( cd usr/bin ; ln -sf lpq-lprng lpq )
( cd usr/bin ; rm -rf lprm )
( cd usr/bin ; ln -sf lprm-lprng lprm )
( cd usr/bin ; rm -rf lpr )
( cd usr/bin ; ln -sf lpr-lprng lpr )
( cd usr/bin ; rm -rf lpstat )
( cd usr/bin ; ln -sf lpstat-lprng lpstat )
( cd usr/bin ; rm -rf lp )
( cd usr/bin ; ln -sf lp-lprng lp )
( cd usr/bin ; rm -rf cancel )
( cd usr/bin ; ln -sf cancel-lprng cancel )
( cd usr/bin ; rm -rf cancel-lprng )
( cd usr/bin ; ln -sf lprm cancel-lprng )
( cd usr/bin ; rm -rf lp-lprng )
( cd usr/bin ; ln -sf lpr lp-lprng )
( cd usr/sbin ; rm -rf lpc )
( cd usr/sbin ; ln -sf lpc-lprng lpc )
( cd usr/lib ; rm -rf liblpr.so.0 )
( cd usr/lib ; ln -sf liblpr.so.0.0.0 liblpr.so.0 )
( cd usr/lib ; rm -rf liblpr.so )
( cd usr/lib ; ln -sf liblpr.so.0.0.0 liblpr.so )
( cd usr/man/man1 ; rm -rf lp.1.gz )
( cd usr/man/man1 ; ln -sf lp-lprng.1.gz lp.1.gz )
( cd usr/man/man1 ; rm -rf cancel.1.gz )
( cd usr/man/man1 ; ln -sf cancel-lprng.1.gz cancel.1.gz )
( cd usr/man/man1 ; rm -rf lpq.1.gz )
( cd usr/man/man1 ; ln -sf lpq-lprng.1.gz lpq.1.gz )
( cd usr/man/man1 ; rm -rf lpr.1.gz )
( cd usr/man/man1 ; ln -sf lpr-lprng.1.gz lpr.1.gz )
( cd usr/man/man1 ; rm -rf lprm.1.gz )
( cd usr/man/man1 ; ln -sf lprm-lprng.1.gz lprm.1.gz )
( cd usr/man/man1 ; rm -rf lpstat.1.gz )
( cd usr/man/man1 ; ln -sf lpstat-lprng.1.gz lpstat.1.gz )
( cd usr/man/man8 ; rm -rf lpc.8.gz )
( cd usr/man/man8 ; ln -sf lpc-lprng.8.gz lpc.8.gz )
