/*
 *  File: SG_ComboBox.h
 *  Project: ShmanssyGUI
 *
 *  Written by: Ivan Leben
 *  Licence: GNU GPL
 *
 */

#ifndef SG_COMBOBOX_H
#define SG_COMBOBOX_H

void SG_OnComboOpenClick(int x, int y, SG_Window *source);
	
class SG_ComboBox : public SG_Window
{
protected:	
	SG_TextBox *txt;
	SG_Button *btn;
	SG_ListBox *lst;
	int selected;

public:	
	SG_ComboBox();
	SG_TextBox* TextBox() {return txt;}
	SG_ListBox* ListBox() {return lst;}
	SG_Button* Button() {return btn;}
	void AddString(char *str);
	void SetListHeight(int h);
	void ShowList(bool bShow);
	int Selection() {return selected;}
	void SetSelection(int index);
	
	//overrides
	virtual void SetBounds(int x, int y, int w, int h);
	virtual void Show(bool isVisible);
};

#endif
