/*
 *  File: SG_Cursor.cpp
 *  Project: ShmanssyGUI
 *
 *  Written by: Ivan Leben
 *  Licence: GNU GPL
 *
 */

#ifndef SG_CURSOR_H
#define SG_CURSOR_H

#define SG_TRANSPARENT 0
#define SG_BLACK 1
#define SG_WHITE 2

class SG_Cursor
{
public:
	SG_Point hotSpot;
	SG_Bitmap bitmap;
	
	void SetHotSpot(SG_Point newHotSpot) {hotSpot = newHotSpot;}
	
	void FromPixels(BYTE *pixels, int width, int height, int format, SG_Point &hotSpot);
	void FromBitmap(SG_Bitmap &bitmap, SG_Point &hotSpot);
	void FromFile(char *fileName);
	void SaveToFile(char *fileName);
};

#endif