/*
 *  File: SG_Layout.h
 *  Project: ShmanssyGUI
 *
 *  Written by: Ivan Leben
 *  Licence: GNU GPL
 *
 */
 
#ifndef SG_LAYOUT_H
#define SG_LAYOUT_H

class SG_Layout
{	
public:
	void *wndTarget;
	SG_Rect bounds;
	LinkedList lstControls;
	
	void SetBounds(int x, int y, int w, int h) {bounds.Set(x,y,w,h);}
	void SetBounds(SG_Rect &rect) {bounds = rect;}
	
	void Add(void *wnd);
	void Remove(void *wnd);
	virtual void Apply();
};

class SG_VerticalLayout : public SG_Layout
{
protected:
	int iSpacing;

public:
	SG_VerticalLayout() {iSpacing = 15;}
	SG_VerticalLayout(int newSpacing) {iSpacing = newSpacing;}
	
	void SetSpacing(int spacing) {iSpacing=spacing; Apply();}
	int GetSpacing() {return iSpacing;}	
	void Apply();
};

class SG_HorizontalLayout : public SG_VerticalLayout
{
public:
	SG_HorizontalLayout() {iSpacing = 15;}
	SG_HorizontalLayout(int newSpacing) {iSpacing = newSpacing;}
	
	void Apply();
};

#endif
