/*
 *  File: SG_ListBox.h
 *  Project: ShmanssyGUI
 *
 *  Written by: Ivan Leben
 *  Licence: GNU GPL
 *
 */

#ifndef SG_LISTBOX_H
#define SG_LISTBOX_H

struct SG_LISTCOL
{
	int width;
	SG_Button *button;
};

struct SG_LISTROW
{
	vector<char*> text;
};

class SG_ListBox : public SG_Window
{
protected:
	int selected;
	SG_Color colSelection;
	SG_Color colSelectionText;
		
public:

	SG_Button *btnTemplate;
	SG_ScrollBar *scroll_bar;
	SG_ScrollBar* Scrollbar() {return scroll_bar;}
	
	SG_ListBox();
	~SG_ListBox();

	bool bShowButtons;
	int row_height;
	int row_width;
	vector<SG_LISTCOL*> columns;
	vector<SG_LISTROW*> rows;
	void ShowButtons(bool show);
	void AddColumn(char *text, int width);
	void AddRow(char *values[]);
	void DeleteRow(int index);
	void AlignButtons();
	void SetColumnWidth(int index, int width);
	void Clear();
	void UpdateScroll();
	int Selection() {return selected;}

	//virtual override
	void SetBounds(int x, int y, int w, int h);
	void SetFont(SG_Font *aFont);
	void Draw(SG_Graphics *gfx);
	virtual void MouseDown(int x, int y);
};

#endif