/*
 *  File: SG_ScrollBar.h
 *  Project: ShmanssyGUI
 *
 *  Written by: Ivan Leben
 *  Licence: GNU GPL
 *
 */

#ifndef SG_SCROLLBAR_H
#define SG_SCROLLBAR_H

#define SB_STEP 5

class SG_ScrollBar : public SG_Window
{
public:
	SG_Button *btnInc;
	SG_Button *btnDec;
	SG_Button *btnSlider;

	SG_ScrollBar(int scroll_type);
	~SG_ScrollBar();

	int type;
	int max;
	int value;
	bool isCustomBehavior;
	bool isSliderGrabed;
	SG_Point sliderSize;
	SG_Point increaseSize;
	SG_Point decreaseSize;
	int railStartMargin, railEndMargin;
	
	void SetMax(int m);
	void SetValue(int v);
	int Max() {return max;}
	int Value() {return value;}
	
	void SetIsCustomBehavior(bool isEnabled) {isCustomBehavior = isEnabled;}
	bool IsCustomBehavior() {return isCustomBehavior;}
	
	void SetSliderSize(int w, int h) {sliderSize.x=w; sliderSize.y=h;}
	void SetIncreaseSize(int w, int h) {increaseSize.x=w; increaseSize.y=h;}
	void SetDecreaseSize(int w, int h) {decreaseSize.x=w; decreaseSize.y=h;}
	void SetRailMargin(int start, int end) {railStartMargin=start; railEndMargin=end;}
	SG_Point& SliderSize() {return sliderSize;}
	SG_Point& IncreaseSize() {return increaseSize;}
	SG_Point& DecreaseSize() {return decreaseSize;}
	
	void UpdateSliderBounds();
	
	SG_Button* IncreaseButton() {return btnInc;}
	SG_Button* DecreaseButton() {return btnDec;}
	SG_Button* SliderButton() {return btnSlider;}

	//virtual overrides
	virtual void Enable(bool enable);
	virtual void SetBounds(int x, int y, int w, int h);
	virtual void Draw(SG_Graphics *gfx);
	void Timer(int time);
	
	//events
	void (*OnChange)(int current_value);
};

//Callbacks
void OnScrollDown(int x, int y, SG_Window *wnd);
void OnScrollUp(int x, int y, SG_Window *wnd);
void OnScrollSliderDown(int x, int y, SG_Window *source);
void OnScrollSliderUp(int x, int y, SG_Window *source);
void OnScrollSliderMove(int x, int y, SG_Window *source);

#endif