/*
 *  File: ShmanssyGUI.h
 *  Project: ShmanssyGUI
 *
 *  Written by: Ivan Leben
 *  Licence: GNU GPL
 *
 */

#ifndef SHMANSSY_GUI_H
#define SHMANSSY_GUI_H

//defines
#define SG_NORMAL	0
#define SG_OPENGL	1

#define SG_WINDOWED		0
#define SG_FULLSCREEN	1

#define SG_FOCUS_FALSE	0
#define SG_FOCUS_TRUE	1

#define SG_MOUSE_NULL	0
#define SG_MOUSE_OVER	1
#define SG_MOUSE_DOWN	2
#define SG_MOUSE_COUNT	3

#define SG_BORDER_NONE		0
#define SG_BORDER_RAISED	1
#define SG_BORDER_SUNKEN	2
#define SG_BORDER_THIN		3

#define SG_HORIZONTAL	0
#define SG_VERTICAL		1

#define SG_ALIGN_LEFT	0
#define SG_ALIGN_RIGHT	1
#define SG_ALIGN_CENTER	2

#define SG_UNCHECKED	0
#define SG_CHECKED		1

//installation folders
#if defined(WIN32)
	#define SG_DATADIR "."
#else
	#define SG_DATADIR CONFIGURE_DATADIR
#endif

//external headers
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "vector"
using namespace std;
#include <math.h>

//OS-specific headers
#if defined(WIN32)
	#include <windows.h>
#endif

//base headers
#include <SDL/SDL.h>
#include <SDL/SDL_thread.h>
#include <SDL/SDL_opengl.h>	
#include <ft2build.h>
#include FT_FREETYPE_H
#include FT_GLYPH_H

//keys
#include "SG_Key.h"

//SG classes and functions
#include "portable.h"
#include "SG_List.h"
#include "SG_String.h"
#include "SG_Bitmap.h"
#include "SG_Font.h"
#include "SG_Graphics.h"
#include "SG_Cursor.h"
#include "SG_SockUtils.h"
#include "SG_Layout.h"
#include "SG_Window.h"
#include "SG_Label.h"
#include "SG_Button.h"
#include "SG_CheckButton.h"
#include "SG_ScrollBar.h"
#include "SG_TextBox.h"
#include "SG_ListBox.h"
#include "SG_ComboBox.h"
#include "SG_ExtendFrame.h"
#include "SG_CheckGroup.h"
#include "SG_ComboBox.h"
#include "SG_ExtendFrame.h"

//Init parameters
extern int SG_videoMode;
extern int SG_windowMode;
extern SG_Point SG_windowSize;
extern SDL_Surface *SG_screen;
extern SG_String SG_dataDir;

//Colors
extern SG_Color SG_colorButtonFace,
				SG_colorButtonText,
				SG_colorWindowBack,
				SG_colorWindowText,
				SG_color3DShadow,
				SG_color3DHilite;

#define SG_COLOR_BUTTONFACE SG_colorButtonFace
#define SG_COLOR_BUTTONTEXT	SG_colorButtonText
#define SG_COLOR_WINDOWBACK SG_colorWindowBack
#define SG_COLOR_WINDOWTEXT SG_colorWindowText
#define SG_COLOR_3DSHADOW	SG_color3DShadow
#define SG_COLOR_3DHILITE	SG_color3DHilite

//Events				 
extern void (*SG_OnWindowResize)(int w, int h);
extern void (*SG_OnKeyDown)(int key);
extern void (*SG_OnKeyUp)(int key);

//Window variables
extern SG_Window *SG_mainWindow;
extern SG_Window *SG_wndMouseCapture;
extern LinkedList SG_windows;
extern LinkedList SG_invalidRectangles;

//Bitmaps
extern SG_Bitmap SG_bitmapArrowLeft;
extern SG_Bitmap SG_bitmapArrowRight;
extern SG_Bitmap SG_bitmapArrowUp;
extern SG_Bitmap SG_bitmapArrowDown;

#define SG_BITMAP_ARROWLEFT		&SG_bitmapArrowLeft
#define SG_BITMAP_ARROWRIGHT	&SG_bitmapArrowRight
#define SG_BITMAP_ARROWUP		&SG_bitmapArrowUp
#define SG_BITMAP_ARROWDOWN		&SG_bitmapArrowDown

//Cursors
extern SG_Point SG_cursorPos;
extern SG_Cursor SG_cursorArrow;
extern SG_Cursor SG_cursorCaret;

#define SG_CURSOR_ARROW &SG_cursorArrow
#define SG_CURSOR_CARET &SG_cursorCaret

//Fonts
extern SG_Font SG_defaultFont;

//functions
int SG_GetTicks();
int SG_UpdateFPS();
bool SG_IsTextualKey(int key);
SG_Window* SG_CreateMainWindow(char *title, int videoMode, int windowMode, int resX, int resY, int bpp);
void SG_EventLoop();
void SG_Quit();
void SG_IntersectRect(SG_Rect &rc1, SG_Rect &rc2, SG_Rect *rcDst);
SG_Window* SG_FindWindow(int x, int y);
void SG_AddWindow(SG_Window *wnd);
void SG_UpdateNestedWindows();
void SG_RedrawWindows();
void SG_RedrawAllWindows();
void SG_InvalidateRect(SG_Rect &rc);
void SG_MouseDown(int x, int y);
void SG_MouseUp(int x, int y);
void SG_MouseMove(int x, int y);
void SG_SetMouseCapture(SG_Window *wnd);
SG_Point SG_CursorPosition();
void SG_SetCursorPosition(int x, int y);
void SG_SetCursorPosition(SG_Point pt);
void SG_CreateThread(int(*threadFunction)(void*), void *data);

#endif
