#!/bin/bash


#  slackbuild script for sword
# Author: Mark Tucker
# Created: Apr 30, 2005
# Changes:
#        Apr 30, 2005 - initial creation
#        Aug 27, 2005 - updated for ver.1.5.8 and sbuild.functions

#
#----------------------------------------------------------------------
umask 0022


#----------------------------------------
# include the common functions
#----------------------------------------
if [ -r ./sbuild.functions ]; then
    . ./sbuild.functions
else
    echo Cannot read file `pwd`/sbuild.functions
    echo Exiting....
    echo
    exit
fi

#----------------------------------------
# Set locations for temp directories
#----------------------------------------
# location of source code archive
srcdir=`pwd`/SRC
workdir=`pwd`


#----------------------------------------
# Package variables
#----------------------------------------
source="sword-1.5.8.tar.bz2"
pkgname="sword"
pkgver="1.5.8"
release="1mht"
package="$pkgname-$pkgver-i486-$release.tgz"
realname="Mark Tucker"
echo Package: $package

#----------------------------------------
# setup path variables
#----------------------------------------
set_workdir

# unpack the source
echo Unpacking the source...
tar -xjf $srcdir/$source


cd $builddir

#----------------------------------------
# setup the build environment
#----------------------------------------
export CFLAGS="-O2 -march=i486 -mcpu=i686"
export CPPFLAGS="-O2 -march=i486 -mcpu=i686"
export CXXFLAGS=$CPPFLAGS

#----------------------------------------
# Build the package and install
#----------------------------------------
# configure 
./configure --prefix=/usr \
    --sysconfdir=/etc \
    --localstatedir=/var \
    > $workdir/config.output 2>&1

if [ $? -ne 0 ]; then
    echo There was a problem with the build process.
    echo check the contents of $workdir/config.output
    echo Exiting...
    exit
fi

#run_configure $conf_opts

# make
run_make

# Set target directory
set_target

# install
run_makeinstall


echo finishing install...


# create install dir
mkdir $target/install

#----------------------------------------
# create slack-desc file to install
#----------------------------------------
cat > $target/install/slack-desc << END
      |-----handy-ruler------------------------------------------------------|
$pkgname: $pkgname $pkgver 
$pkgname:
$pkgname: Libraries for accessing various Bible texts.
$pkgname: 
$pkgname: 
$pkgname: 
$pkgname:
$pkgname: 
$pkgname: http://www.crosswire.org/sword/
$pkgname: 
$pkgname: Packaged by Mark Tucker for Slackware 10.0
END


# create documentation directory
create_docdir

# fix group on bin directories.
fix_bingrp

# strip  bin files
strip_bin

# strip lib files
strip_libs

# check for uncompressed man pages
compr_man

# makepkg
create_pkg

exit
