#----------------------------------------------------------------------
# Name:        wx.lib.aanalogclockopts
# Purpose:     An analog clock window - setup frame
#
# Author:      E. A. Tacao
#
# Created:     15-February-2004
#----------------------------------------------------------------------

# Originally generated by wx.Glade 0.3.1 on Wed Feb 18 00:05:35 2004
# Converted to wx namespace by Peter Damoc


import wx
import wx.lib.colourselect as  csel
import wx.lib.dialogs as  dlgs
import string

class ACCustomizationFrame(wx.Frame):
    def __init__(self, parent, id, name, pos=wx.DefaultPosition, size=wx.DefaultSize,
                 style=wx.DEFAULT_FRAME_STYLE | wx.FRAME_NO_TASKBAR | wx.FRAME_FLOAT_ON_PARENT | wx.WANTS_CHARS):
        #  k=wx.NewId();ide=map(lambda x: x+k, range(0,100))
        ide = [wx.NewId() for i in range(100)]

        #kwds["style"] = wx.CAPTION|wx.SYSTEM_MENU
        #wx.Frame.__init__(self, *args, **kwds)
        wx.Frame.__init__(self, parent, id, name, pos, size, style)
        self.parent=parent
        self.panel_1 = wx.Panel(self, -1)
        self.notebook_1 = wx.Notebook(self.panel_1, -1, style=0)
        self.notebook_1_pane_3 = wx.Panel(self.notebook_1, -1)
        self.notebook_1_pane_2 = wx.Panel(self.notebook_1, -1)
        self.notebook_1_pane_1 = wx.Panel(self.notebook_1, -1)
        self.label_top = wx.StaticText(self.panel_1, -1, "Use the options below to change the clock;\nthe main buttons on top of each category reset to its defaults.")
        self.static_line_1 = wx.StaticLine(self.panel_1, -1)
        self.button_1 = wx.Button(self.notebook_1_pane_1, ide[1], "SetClockStyle")
        self.static_line_2 = wx.StaticLine(self.notebook_1_pane_1, -1)
        self.button_2 = wx.Button(self.notebook_1_pane_1, ide[3], "styles...")
        self.static_line_3 = wx.StaticLine(self.notebook_1_pane_1, -1, style=wx.LI_VERTICAL)
        self.button_3 = wx.Button(self.notebook_1_pane_1, ide[2], "SetTickStyles")
        self.static_line_4 = wx.StaticLine(self.notebook_1_pane_1, -1)
        self.button_4 = wx.Button(self.notebook_1_pane_1, ide[4], "styles...")
        self.button_22 = wx.Button(self.notebook_1_pane_1, ide[22], "minutes...")
        self.static_line_5 = wx.StaticLine(self.notebook_1_pane_1, -1)
        self.button_5 = wx.Button(self.notebook_1_pane_1, ide[5], "SetShadowColour")
        self.static_line_6 = wx.StaticLine(self.notebook_1_pane_1, -1)
        self.button_6 = csel.ColourSelect(self.notebook_1_pane_1, ide[6], "all...")
        self.static_line_7 = wx.StaticLine(self.notebook_1_pane_1, -1, style=wx.LI_VERTICAL)
        self.button_7 = wx.Button(self.notebook_1_pane_1, ide[7], "SetWatchPenBrush")
        self.static_line_8 = wx.StaticLine(self.notebook_1_pane_1, -1)
        self.button_8 = csel.ColourSelect(self.notebook_1_pane_1, ide[8], "Pen colour...")
        self.button_9 = csel.ColourSelect(self.notebook_1_pane_1, ide[9], "Brush colour...")
        self.button_10 = wx.Button(self.notebook_1_pane_2, ide[10], "SetTickColours")
        self.static_line_8 = wx.StaticLine(self.notebook_1_pane_2, -1)
        self.button_11 = csel.ColourSelect(self.notebook_1_pane_2, ide[11], "hours...", colour=self.parent.tickMarkHoursPen.GetColour())
        self.button_12 = csel.ColourSelect(self.notebook_1_pane_2, ide[12], "minutes...", colour=self.parent.tickMarkMinutesPen.GetColour())
        self.static_line_10 = wx.StaticLine(self.notebook_1_pane_2, -1, style=wx.LI_VERTICAL)
        self.button_13 = wx.Button(self.notebook_1_pane_2, ide[13], "SetTickSizes")
        self.static_line_11 = wx.StaticLine(self.notebook_1_pane_2, -1)
        self.label_1 = wx.StaticText(self.notebook_1_pane_2, -1, "hours")
        self.spin_ctrl_1 = wx.SpinCtrl(self.notebook_1_pane_2, ide[71], "10", min=1, max=100)
        self.label_2 = wx.StaticText(self.notebook_1_pane_2, -1, "minutes")
        self.spin_ctrl_2 = wx.SpinCtrl(self.notebook_1_pane_2, ide[72], "5", min=0, max=100)
        self.label_3 = wx.StaticText(self.notebook_1_pane_2, -1, "offset")
        self.spin_ctrl_3 = wx.SpinCtrl(self.notebook_1_pane_2, ide[73], "0", min=0, max=100)
        self.static_line_12 = wx.StaticLine(self.notebook_1_pane_2, -1, style=wx.LI_VERTICAL)
        self.button_14 = wx.Button(self.notebook_1_pane_2, ide[14], "SetTickFonts")
        self.static_line_13 = wx.StaticLine(self.notebook_1_pane_2, -1)
        self.button_15 = wx.Button(self.notebook_1_pane_2, ide[15], "hours...")
        self.button_16 = wx.Button(self.notebook_1_pane_2, ide[16], "minutes...")
        self.button_17 = wx.Button(self.notebook_1_pane_3, ide[17], "SetHandWeights")
        self.static_line_14 = wx.StaticLine(self.notebook_1_pane_3, -1)
        self.label_4 = wx.StaticText(self.notebook_1_pane_3, -1, "hours")
        self.spin_ctrl_4 = wx.SpinCtrl(self.notebook_1_pane_3, ide[74], "5", min=0, max=100)
        self.label_5 = wx.StaticText(self.notebook_1_pane_3, -1, "minutes")
        self.spin_ctrl_5 = wx.SpinCtrl(self.notebook_1_pane_3, ide[75], "3", min=0, max=100)
        self.label_6 = wx.StaticText(self.notebook_1_pane_3, -1, "seconds")
        self.spin_ctrl_6 = wx.SpinCtrl(self.notebook_1_pane_3, ide[76], "1", min=0, max=100)
        self.static_line_15 = wx.StaticLine(self.notebook_1_pane_3, -1, style=wx.LI_VERTICAL)
        self.button_18 = wx.Button(self.notebook_1_pane_3, ide[18], "SetHandColours")
        self.static_line_16 = wx.StaticLine(self.notebook_1_pane_3, -1)
        self.button_19 = csel.ColourSelect(self.notebook_1_pane_3, ide[19], "hours...")
        self.button_20 = csel.ColourSelect(self.notebook_1_pane_3, ide[20], "minutes...")
        self.button_21 = csel.ColourSelect(self.notebook_1_pane_3, ide[21], "seconds...")

        self.__set_properties()
        self.__do_layout()


        self.Bind(wx.EVT_BUTTON, self.OnEventsHook, id=ide[0], id2=ide[29])
        self.Bind(csel.EVT_COLOURSELECT, self.OnEventsHook, id=ide[0], id2=ide[29])
        self.Bind(wx.EVT_SPINCTRL, self.OnEventsHook, id=ide[71], id2=ide[80])
        self.Bind(wx.EVT_RADIOBUTTON, self.OnEventsHook, id=ide[51], id2=ide[60])
        self.Bind(wx.EVT_WINDOW_DESTROY, self.OnQuit)

        self.ide=ide

    def __set_properties(self):
        #self.SetTitle("AnalogClock Test")
        self.spin_ctrl_1.SetSize((50, -1))
        self.spin_ctrl_2.SetSize((50, -1))
        self.spin_ctrl_3.SetSize((50, -1))
        self.spin_ctrl_4.SetSize((50, -1))
        self.spin_ctrl_5.SetSize((50, -1))
        self.spin_ctrl_6.SetSize((50, -1))


    def __do_layout(self):
        sizer_frame = wx.BoxSizer(wx.HORIZONTAL)
        sizer_main = wx.BoxSizer(wx.VERTICAL)
        sizer_25 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_26 = wx.StaticBoxSizer(wx.StaticBox(self.notebook_1_pane_3, -1, ""), wx.VERTICAL)
        sizer_27 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_31 = wx.BoxSizer(wx.VERTICAL)
        sizer_33 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_32 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_28 = wx.BoxSizer(wx.VERTICAL)
        sizer_30 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_29 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_12 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_13 = wx.StaticBoxSizer(wx.StaticBox(self.notebook_1_pane_2, -1, ""), wx.VERTICAL)
        sizer_14 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_22 = wx.BoxSizer(wx.VERTICAL)
        sizer_24 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_23 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_18 = wx.BoxSizer(wx.VERTICAL)
        sizer_21 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_20 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_19 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_15 = wx.BoxSizer(wx.VERTICAL)
        sizer_17 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_16 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_1 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_2 = wx.StaticBoxSizer(wx.StaticBox(self.notebook_1_pane_1, -1, ""), wx.VERTICAL)
        sizer_8 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_11 = wx.BoxSizer(wx.VERTICAL)
        sizer_12b = wx.BoxSizer(wx.HORIZONTAL)
        sizer_9 = wx.BoxSizer(wx.VERTICAL)
        sizer_10 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_3 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_6 = wx.BoxSizer(wx.VERTICAL)
        sizer_7 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_4 = wx.BoxSizer(wx.VERTICAL)
        sizer_5 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_main.Add(self.label_top, 0, wx.LEFT|wx.TOP, 5)
        sizer_main.Add(self.static_line_1, 0, wx.TOP|wx.BOTTOM|wx.EXPAND, 10)
        sizer_4.Add(self.button_1, 0, wx.ALL|wx.ALIGN_CENTER_HORIZONTAL|wx.ALIGN_CENTER_VERTICAL, 5)
        sizer_4.Add(self.static_line_2, 0, wx.LEFT|wx.RIGHT|wx.EXPAND, 20)
        sizer_5.Add(self.button_2, 0, wx.ALL|wx.ALIGN_CENTER_VERTICAL, 5)
        sizer_4.Add(sizer_5, 1, wx.ALIGN_CENTER_HORIZONTAL, 0)
        sizer_3.Add(sizer_4, 1, wx.EXPAND, 0)
        sizer_3.Add(self.static_line_3, 0, wx.EXPAND, 0)
        sizer_6.Add(self.button_3, 0, wx.ALL|wx.ALIGN_CENTER_HORIZONTAL|wx.ALIGN_CENTER_VERTICAL, 5)
        sizer_6.Add(self.static_line_4, 0, wx.LEFT|wx.RIGHT|wx.EXPAND, 20)
        sizer_7.Add(self.button_4, 0, wx.ALL|wx.ALIGN_CENTER_VERTICAL, 5)
        sizer_7.Add(self.button_22, 0, wx.ALL|wx.ALIGN_CENTER_VERTICAL, 5)
        sizer_6.Add(sizer_7, 1, wx.ALIGN_CENTER_HORIZONTAL, 0)
        sizer_3.Add(sizer_6, 1, wx.EXPAND, 0)
        sizer_2.Add(sizer_3, 1, wx.EXPAND, 0)
        sizer_2.Add(self.static_line_5, 0, wx.EXPAND, 0)
        sizer_9.Add(self.button_5, 0, wx.ALL|wx.ALIGN_CENTER_HORIZONTAL|wx.ALIGN_CENTER_VERTICAL, 5)
        sizer_9.Add(self.static_line_6, 0, wx.LEFT|wx.RIGHT|wx.EXPAND, 20)
        sizer_10.Add(self.button_6, 0, wx.ALL|wx.ALIGN_CENTER_VERTICAL, 5)
        sizer_9.Add(sizer_10, 1, wx.ALIGN_CENTER_HORIZONTAL, 0)
        sizer_8.Add(sizer_9, 1, wx.EXPAND, 0)
        sizer_8.Add(self.static_line_7, 0, wx.EXPAND, 0)
        sizer_11.Add(self.button_7, 0, wx.ALL|wx.ALIGN_CENTER_HORIZONTAL|wx.ALIGN_CENTER_VERTICAL, 5)
        sizer_11.Add(self.static_line_8, 0, wx.LEFT|wx.RIGHT|wx.EXPAND, 20)
        sizer_12b.Add(self.button_8, 0, wx.ALL|wx.ALIGN_CENTER_VERTICAL, 5)
        sizer_12b.Add(self.button_9, 0, wx.ALL|wx.ALIGN_CENTER_VERTICAL, 5)
        sizer_11.Add(sizer_12b, 1, wx.ALIGN_CENTER_HORIZONTAL, 0)
        sizer_8.Add(sizer_11, 1, wx.EXPAND, 0)
        sizer_2.Add(sizer_8, 1, wx.EXPAND, 0)
        sizer_1.Add(sizer_2, 1, wx.EXPAND, 0)
        self.notebook_1_pane_1.SetAutoLayout(1)
        self.notebook_1_pane_1.SetSizer(sizer_1)
        sizer_1.Fit(self.notebook_1_pane_1)
        sizer_1.SetSizeHints(self.notebook_1_pane_1)
        sizer_15.Add(self.button_10, 0, wx.ALL|wx.ALIGN_CENTER_HORIZONTAL|wx.ALIGN_CENTER_VERTICAL, 5)
        sizer_15.Add(self.static_line_8, 0, wx.LEFT|wx.RIGHT|wx.EXPAND, 20)
        sizer_16.Add(self.button_11, 0, wx.ALL|wx.ALIGN_CENTER_HORIZONTAL|wx.ALIGN_CENTER_VERTICAL, 5)
        sizer_15.Add(sizer_16, 1, wx.ALIGN_CENTER_HORIZONTAL, 0)
        sizer_17.Add(self.button_12, 0, wx.ALL|wx.ALIGN_CENTER_HORIZONTAL|wx.ALIGN_CENTER_VERTICAL, 5)
        sizer_15.Add(sizer_17, 1, wx.ALIGN_CENTER_HORIZONTAL, 0)
        sizer_14.Add(sizer_15, 1, wx.EXPAND, 0)
        sizer_14.Add(self.static_line_10, 0, wx.EXPAND, 0)
        sizer_18.Add(self.button_13, 0, wx.ALL|wx.ALIGN_CENTER_HORIZONTAL|wx.ALIGN_CENTER_VERTICAL, 5)
        sizer_18.Add(self.static_line_11, 0, wx.LEFT|wx.RIGHT|wx.EXPAND, 20)
        sizer_19.Add(self.label_1, 0, wx.ALL|wx.ALIGN_CENTER_VERTICAL, 5)
        sizer_19.Add(self.spin_ctrl_1, 0, wx.ALL|wx.ALIGN_CENTER_VERTICAL, 5)
        sizer_18.Add(sizer_19, 1, wx.ALIGN_CENTER_HORIZONTAL, 0)
        sizer_20.Add(self.label_2, 0, wx.ALL|wx.ALIGN_CENTER_VERTICAL, 5)
        sizer_20.Add(self.spin_ctrl_2, 0, wx.ALL|wx.ALIGN_CENTER_VERTICAL, 5)
        sizer_18.Add(sizer_20, 1, wx.ALIGN_CENTER_HORIZONTAL, 0)
        sizer_21.Add(self.label_3, 0, wx.ALL|wx.ALIGN_CENTER_VERTICAL, 5)
        sizer_21.Add(self.spin_ctrl_3, 0, wx.ALL|wx.ALIGN_CENTER_VERTICAL, 5)
        sizer_18.Add(sizer_21, 1, wx.ALIGN_CENTER_HORIZONTAL, 0)
        sizer_14.Add(sizer_18, 1, wx.EXPAND, 0)
        sizer_14.Add(self.static_line_12, 0, wx.EXPAND, 0)
        sizer_22.Add(self.button_14, 0, wx.ALL|wx.ALIGN_CENTER_HORIZONTAL|wx.ALIGN_CENTER_VERTICAL, 5)
        sizer_22.Add(self.static_line_13, 0, wx.LEFT|wx.RIGHT|wx.EXPAND, 20)
        sizer_23.Add(self.button_15, 0, wx.ALL|wx.ALIGN_CENTER_HORIZONTAL|wx.ALIGN_CENTER_VERTICAL, 5)
        sizer_22.Add(sizer_23, 1, wx.ALIGN_CENTER_HORIZONTAL, 0)
        sizer_24.Add(self.button_16, 0, wx.ALL|wx.ALIGN_CENTER_HORIZONTAL|wx.ALIGN_CENTER_VERTICAL, 5)
        sizer_22.Add(sizer_24, 1, wx.ALIGN_CENTER_HORIZONTAL, 0)
        sizer_14.Add(sizer_22, 1, wx.EXPAND, 0)
        sizer_13.Add(sizer_14, 1, wx.EXPAND, 0)
        sizer_12.Add(sizer_13, 1, wx.EXPAND, 0)
        self.notebook_1_pane_2.SetAutoLayout(1)
        self.notebook_1_pane_2.SetSizer(sizer_12)
        sizer_12.Fit(self.notebook_1_pane_2)
        sizer_12.SetSizeHints(self.notebook_1_pane_2)
        sizer_28.Add(self.button_17, 0, wx.ALL|wx.ALIGN_CENTER_HORIZONTAL|wx.ALIGN_CENTER_VERTICAL, 5)
        sizer_28.Add(self.static_line_14, 0, wx.LEFT|wx.RIGHT|wx.EXPAND, 20)
        sizer_29.Add(self.label_4, 0, wx.ALL|wx.ALIGN_RIGHT|wx.ALIGN_CENTER_VERTICAL, 5)
        sizer_29.Add(self.spin_ctrl_4, 0, wx.ALL|wx.ALIGN_CENTER_VERTICAL, 5)
        sizer_29.Add(self.label_5, 0, wx.ALL|wx.ALIGN_RIGHT|wx.ALIGN_CENTER_VERTICAL, 5)
        sizer_29.Add(self.spin_ctrl_5, 0, wx.ALL|wx.ALIGN_CENTER_VERTICAL, 5)
        sizer_28.Add(sizer_29, 1, wx.ALIGN_CENTER_HORIZONTAL, 0)
        sizer_30.Add(self.label_6, 0, wx.ALL|wx.ALIGN_RIGHT|wx.ALIGN_CENTER_VERTICAL, 5)
        sizer_30.Add(self.spin_ctrl_6, 0, wx.ALL|wx.ALIGN_CENTER_VERTICAL, 5)
        sizer_28.Add(sizer_30, 1, wx.ALIGN_CENTER_HORIZONTAL, 0)
        sizer_27.Add(sizer_28, 1, wx.EXPAND, 0)
        sizer_27.Add(self.static_line_15, 0, wx.EXPAND, 0)
        sizer_31.Add(self.button_18, 0, wx.ALL|wx.ALIGN_CENTER_HORIZONTAL|wx.ALIGN_CENTER_VERTICAL, 5)
        sizer_31.Add(self.static_line_16, 0, wx.LEFT|wx.RIGHT|wx.EXPAND, 20)
        sizer_32.Add(self.button_19, 0, wx.ALL|wx.ALIGN_CENTER_VERTICAL, 5)
        sizer_32.Add(self.button_20, 0, wx.ALL|wx.ALIGN_CENTER_VERTICAL, 5)
        sizer_31.Add(sizer_32, 1, wx.ALIGN_CENTER_HORIZONTAL, 0)
        sizer_33.Add(self.button_21, 0, wx.ALL|wx.ALIGN_CENTER_VERTICAL, 5)
        sizer_31.Add(sizer_33, 1, wx.ALIGN_CENTER_HORIZONTAL, 0)
        sizer_27.Add(sizer_31, 1, wx.EXPAND, 0)
        sizer_26.Add(sizer_27, 1, wx.EXPAND, 0)
        sizer_25.Add(sizer_26, 1, wx.EXPAND, 0)
        self.notebook_1_pane_3.SetAutoLayout(1)
        self.notebook_1_pane_3.SetSizer(sizer_25)
        sizer_25.Fit(self.notebook_1_pane_3)
        sizer_25.SetSizeHints(self.notebook_1_pane_3)
        self.notebook_1.AddPage(self.notebook_1_pane_1, "Clock")
        self.notebook_1.AddPage(self.notebook_1_pane_2, "Ticks")
        self.notebook_1.AddPage(self.notebook_1_pane_3, "Hands")
        sizer_main.Add(wx.NotebookSizer(self.notebook_1), 1, wx.LEFT|wx.RIGHT|wx.BOTTOM|wx.EXPAND, 5)
        self.panel_1.SetAutoLayout(1)
        self.panel_1.SetSizer(sizer_main)
        sizer_main.Fit(self.panel_1)
        sizer_main.SetSizeHints(self.panel_1)
        sizer_frame.Add(self.panel_1, 1, wx.EXPAND|wx.ALIGN_CENTER_HORIZONTAL|wx.ALIGN_CENTER_VERTICAL, 0)
        self.SetAutoLayout(1)
        self.SetSizer(sizer_frame)
        sizer_frame.Fit(self)
        sizer_frame.SetSizeHints(self)
        self.Layout()
        self.UpdateWidgets()

    def UpdateAll(self):
        self.UpdateWidgets()
        self.parent.OnSize(None)

    def UpdateWidgets(self):
        self.button_6.SetColour(self.parent.shadowPenColour)

        bc=self.parent.watchPen
        if bc:
            bc=bc.GetColour()
        else:
            bc=self.parent.GetBackgroundColour()
        self.button_8.SetColour(bc)

        bc=self.parent.watchBrush
        if bc:
            bc=bc.GetColour()
        else:
            bc=self.parent.GetBackgroundColour()
        self.button_9.SetColour(bc)

        self.button_11.SetColour(self.parent.tickMarkHoursPen.GetColour())
        self.button_12.SetColour(self.parent.tickMarkMinutesPen.GetColour())
        self.button_19.SetColour(self.parent.handHoursColour)
        self.button_20.SetColour(self.parent.handMinutesColour)
        self.button_21.SetColour(self.parent.handSecondsColour)
        
        self.spin_ctrl_1.SetValue(self.parent.markSizeHour)
        self.spin_ctrl_2.SetValue(self.parent.markSizeMin)
        self.spin_ctrl_3.SetValue(self.parent.offM)
        self.spin_ctrl_4.SetValue(self.parent.handHoursThickness)
        self.spin_ctrl_5.SetValue(self.parent.handMinutesThickness)
        self.spin_ctrl_6.SetValue(self.parent.handSecondsThickness)


    def gfid(self, id, lista):
        return self.ide.index(id) in lista
        #  for x in lista:
            #  if id==self.ide[x]:
                #  f=True
                #  break
        #  else:
            #  f=False
        #  return f

    def OnEventsHook(self, evt):
        id=evt.GetId()

        if self.gfid(id, [6,8,9,11,12,19,20,21,23]):
            self.OnSelectColour(evt)
            
        elif self.gfid(id, [15,16]):
            self.OnSelectFont(evt)

        elif self.gfid(id, [71,72,73,74,75,76]):
            self.OnSpinChange(evt)
            
        elif self.gfid(id, [3,4,22]):
            self.OnChangeStyle(evt)

        elif self.gfid(id, [1,2,5,7,10,13,14,17,18]):
            self.OnDefaults(evt)

    def OnSelectColour(self, evt):
        id=evt.GetId();colour=evt.GetValue()

        if id==self.ide[6]:
            self.parent.SetShadowColour(colour)
        elif id==self.ide[8]:
            self.parent.SetWatchPenBrush(p=wx.Pen(colour, 1, wx.SOLID))
        elif id==self.ide[9]:
            self.parent.SetWatchPenBrush(b=wx.Brush(colour, wx.SOLID))
        elif id==self.ide[11]:
            self.parent.SetTickColours(h=colour)
        elif id==self.ide[12]:
            self.parent.SetTickColours(m=colour)
        elif id==self.ide[19]:
            self.parent.SetHandColours(h=colour)
        elif id==self.ide[20]:
            self.parent.SetHandColours(m=colour)
        elif id==self.ide[21]:
            self.parent.SetHandColours(s=colour)


        self.UpdateAll()



    def OnSelectFont(self, evt):
        id=evt.GetId()
        if id==self.ide[15]:
            font=self.parent.tickMarkHoursFont;font.SetPointSize(self.parent.markSizeHour)
            colour=self.parent.tickMarkHoursPen.GetColour()
        else:
            font=self.parent.tickMarkMinutesFont;font.SetPointSize(self.parent.markSizeMin)
            colour=self.parent.tickMarkMinutesPen.GetColour()

        data = wx.FontData()
        data.EnableEffects(True)
        data.SetColour(colour)
        data.SetInitialFont(font)

        dlg = wx.FontDialog(self, data)
        if dlg.ShowModal() == wx.ID_OK:
            data = dlg.GetFontData()
            font = data.GetChosenFont()
            colour = data.GetColour()
            if id==self.ide[15]:
                self.parent.SetTickFonts(h=font)
                self.parent.SetTickColours(h=colour.Get())
            else:
                self.parent.SetTickFonts(m=font)
                self.parent.SetTickColours(m=colour.Get())
        dlg.Destroy()

        self.UpdateAll()

    def OnSpinChange(self, evt):
        id=evt.GetId();v=evt.GetInt()
        if id==self.ide[71]:
            self.parent.SetTickSizes(h=v)
        if id==self.ide[72]:
            self.parent.SetTickSizes(m=v)
        if id==self.ide[73]:
            self.parent.SetMinutesOffset(v)
        if id==self.ide[74]:
            self.parent.SetHandWeights(h=v)
        if id==self.ide[75]:
            self.parent.SetHandWeights(m=v)
        if id==self.ide[76]:
            self.parent.SetHandWeights(s=v)

        self.UpdateAll()

    def OnChangeStyle(self, evt):
        id=evt.GetId()

        if id==self.ide[3]:
            x="""SHOW_QUARTERS_TICKS
                 SHOW_HOURS_TICKS
                 SHOW_MINUTES_TICKS
                 ROTATE_TICKS
                 SHOW_HOURS_HAND
                 SHOW_MINUTES_HAND
                 SHOW_SECONDS_HAND
                 SHOW_SHADOWS
                 OVERLAP_TICKS""".split()
            m=map(lambda f: (self.parent.clockStyle & f)/f, map(lambda f: 2**x.index(f),x))

            dlg = dlgs.MultipleChoiceDialog(self,
                                         "Select some styles for the clock:",
                                         "Styles", x)
            for i in range(0,len(m)):
                if m[i]:
                    dlg.lbox.SetSelection(i)

            if (dlg.ShowModal() == wx.ID_OK):
                v=reduce(lambda x,y:x+y,map(lambda f: 2**f,dlg.GetValue()))
                self.parent.SetClockStyle(v)

        elif id==self.ide[4]:
            x="""TICKS_NONE
                 TICKS_SQUARE
                 TICKS_CIRCLE
                 TICKS_POLY
                 TICKS_DECIMAL
                 TICKS_ROMAN""".split()
            m=map(lambda f: (self.parent.tickMarkHoursStyle & f)/f, map(lambda f: 2**x.index(f),x))

            dlg = wx.SingleChoiceDialog(self,
                                       "Select a style for the hours:",
                                       "Styles", x, wx.CHOICEDLG_STYLE)
            for i in range(0,len(m)):
                if m[i]:
                    dlg.SetSelection(i)

            if dlg.ShowModal() == wx.ID_OK:
                v=2**dlg.GetSelection()
                self.parent.SetTickStyles(h=v)
            dlg.Destroy()

        elif id==self.ide[22]:
            tipo="for the minutes"
            x="""TICKS_NONE
                 TICKS_SQUARE
                 TICKS_CIRCLE
                 TICKS_POLY
                 TICKS_DECIMAL
                 TICKS_ROMAN""".split()
            m=map(lambda f: (self.parent.tickMarkMinutesStyle & f)/f, map(lambda f: 2**x.index(f),x))

            dlg = wx.SingleChoiceDialog(self,
                                       "Select a style for the minutes:",
                                       "Styles", x, wx.CHOICEDLG_STYLE)
            for i in range(0,len(m)):
                if m[i]:
                    dlg.SetSelection(i)

            if dlg.ShowModal() == wx.ID_OK:
                v=2**dlg.GetSelection()
                self.parent.SetTickStyles(m=v)
            dlg.Destroy()

        self.UpdateAll()

    def OnDefaults(self, evt):
        id=evt.GetId()
        if id==self.ide[1]:
            self.parent.SetClockStyle(142)
        elif id==self.ide[2]:
            self.parent.SetTickStyles(8, 4)
        elif id==self.ide[5]:
            self.parent.SetShadowColour((128,128,128))
        elif id==self.ide[7]:
            colour=self.parent.GetBackgroundColour()
            self.parent.SetWatchPenBrush(p=wx.Pen(colour, 1, wx.SOLID), b=wx.Brush(colour, wx.SOLID))
        elif id==self.ide[10]:
            colour=(0, 0, 0)
            self.parent.SetTickColours(h=colour, m=colour)
        elif id==self.ide[13]:
            self.parent.SetTickSizes(h=10, m=5)
            self.parent.SetMinutesOffset(0)
        elif id==self.ide[14]:
            self.parent.SetTickFonts(wx.Font(1, wx.SWISS, wx.NORMAL, wx.BOLD))
        elif id==self.ide[17]:
            self.parent.SetHandWeights(h=5, m=3, s=1)
        elif id==self.ide[18]:
            colour=(0, 0, 0)
            self.parent.SetHandColours(h=colour, m=colour, s=colour)

        self.UpdateAll()


    def OnQuit(self, evt):
        self.parent.prefs_open=False


#
##
### eof



