from bzrlib.transport import get_transport
from bzrtools import iter_branches, apache_ls

def branches(location=None):
    if location is None:
        location = '.'
    t = get_transport(location)
    if location.startswith('http://'):
        lister = apache_ls
    elif not t.listable():
        print "Can't list this type of location."
        return 3
    else:
        lister = None
    for branch in iter_branches(t, lister):
        print branch.base[len(t.base):].rstrip('/')
