#!/bin/sh
config() {
  NEW="$1"
  OLD="`dirname $NEW`/`basename $NEW .new`"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "`cat $OLD | md5sum`" = "`cat $NEW | md5sum`" ]; then # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}

config etc/etter.conf.new
config usr/share/ettercap/etter.dns.new
config usr/share/ettercap/etter.fields.new
config usr/share/ettercap/etter.filter.examples.new
config usr/share/ettercap/etter.filter.kill.new
config usr/share/ettercap/etter.filter.new
config usr/share/ettercap/etter.filter.ssh.new
config usr/share/ettercap/etter.finger.mac.new
config usr/share/ettercap/etter.finger.os.new
config usr/share/ettercap/etter.mime.new
config usr/share/ettercap/etter.services.new
config usr/share/ettercap/etter.ssl.crt.new
config usr/share/ettercap/ettercap.png.new
config usr/share/ettercap/etterfilter.cnt.new
config usr/share/ettercap/etterfilter.tbl.new
config usr/share/ettercap/etterlog.dtd.new


