#! /bin/bash
# hibernate, when battery runs out
# adapted from lm_battery.sh from laptop-mode
BATT_INFO=/proc/acpi/battery/$2/state
MINIMUM_BATTERY_MINUTES=5
if [ -f $BATT_INFO ]; then
	ACTION=$(cat $BATT_INFO | grep charging | cut -c 26-)
	PRESENT_RATE=$(cat $BATT_INFO | grep "present rate:" | sed  "s/.* \([0-9][0-9]* \).*/\1/")
	if [[ $ACTION == "discharging" && $PRESENT_RATE != 0 ]]; then
		REMAINING=$(cat $BATT_INFO | grep "remaining capacity:" | sed  "s/.* \([0-9][0-9]* \).*/\1/")
		if (( $REMAINING * 60 / $PRESENT_RATE < $MINIMUM_BATTERY_MINUTES )); then
			/usr/sbin/hibernate
		fi
	fi
fi
