#!/bin/sh
#
# This script is copyright 2001 by A.L.Lambert.  It is distributed under the
# GNU public license.  If you don't know what this means, I suggest you point
# a web browser at www.gnu.org and find out.
#
# 2005 this script based on the original logtool_logcheck.sh script and is now 
#named checkLog.sh - David Matthews dmatthews@mailc.net
# As well as retail, the logtool programe is recommended

#edit the this method to suit your system and what you prefer to see
#retail should read incrementally any log file you choose
report(){
	echo "Messages from secure" >> $TEMP
	echo "---------------------------------" >> $TEMP
	#this should work and be of interest on any standard slackware system
	retail "/var/log/secure" |  >> $TEMP
	echo "---------------------------------" >> $TEMP
#	echo "Firewall messages" > $TEMP
#	echo "---------------------------------" >> $TEMP
#	#if you don't log firewall messages to /var/log/firewall, 
#	#you might like to download my arnos-iptables-firewall slackware package
#	#otherwise iptables stuff will probably be in messages or syslog
#	retail "/var/log/firewall" | grep 'iptables'  >> $TEMP
#	#better still, if you have logtool installed you can do this instead
#	retail "/var/log/firewall" | logtool -o ASCII | grep 'iptables'  >> $TEMP
#	echo "---------------------------------" >> $TEMP
#	#if you have your own mail server, you'll want something like this
#	echo "Mail undelivered" >> $TEMP
#	echo "---------------------------------" >> $TEMP
#	retail "/var/log/maillog" | grep 'failure' >> $TEMP
#	echo "---------------------------------" >> $TEMP
	
}

#edit address to send mail
MAIL="user@domain"

#==no editing below here===========================================================

NAME=`basename "$0"`
DATE=`date +%m/%d/%y:%H.%M`

# we need a tempfile name
# see if we've got mktmp, and if we do, use it.
if [ -x `which mktemp` ] ; then
	TEMP=`mktemp -q /tmp/$NAME.XXXXXX`
	if [ $? -ne 0 ]; then
			# oops; we got it, but it's not working right; complain to user about it
			echo "$NAME: Can't create temp file, exiting..."
			exit 1
	fi
else 
	# NOT INCREDIBLY SECURE!!! DO SOMETHING BETTER IF YOU WANT
	TEMP=/tmp/$$.$RANDOM.$$.logtool.check
fi

# go read the logs
report

# if we found anything, load it into a memory variable
FOUND="`head $TEMP`"

# if there wasn't nothing found, then we can bail out
if [ "$FOUND" = "" ] ; then
	rm -f $TEMP /var/run/logtool.check
	exit 0
else
	# pump that tmpfile into the mail post-haste.
	cat $TEMP | mail -s "Check log report $DATE" $MAIL
	rm -f $TEMP

fi 

exit 0

