/* Ast.h - Copyright (c) Marc Krisnanto */

#ifndef _H_Ast_
#define _H_Ast_ 1


/** Ast
	The final Ast class.
*/
extern Class AstClass;


/** TAst
	This represents an instance of the Ast class.

	We could create tons of Ast subclasses but that will need a tremendous
	amount of code just to print them. So we don't do it. Until know this
	only Ast class works fine.

	@warn
	v{cursor} needs to point to the source code String thus the String
	must be referenced. The root Ast and the source code String is stored
	in the corresponding ={Module} object.

	@p
	The v{line} field is there so that we don't need to look it up when
	printing an error message or the Ast. This is important if you consider
	that a program might call C{eval} a lot of times.
*/
struct TAst
{
	OBJ_HEAD;
	Ast         next;   /* Sibling node */
	Ast         child;  /* First child node */
	int         type;   /* One of AstType (see below) */
	const char *cursor; /* Position in source code */
	long        line;   /* Line number */
	long        op;     /* Flag, operator, etc. */
	Any         thing;  /* Any object */
};


/** AstIs
	Whether or not the object is a Ast.
*/
#define AstIs(o) (ClassOf (o) == AstClass)


/** AstNewr AstNewp
	Create a new Ast object.

	v{type} must be one of #{AstType}.

	v{cursor} is the cursor position in the source code.

	v{line} is the line number.

	Use AstNewr to create a "rule" node.
	This node does not contain information about the cursor position in the
	source code.

	Use AstNewp to create a "production" node.
	This node contains information about the cursor position in the source code.

	The theory is that we should never display error messages using "rule" nodes.
	The two functions is more efficient than just one.
*/
extern Ast AstNewr (int type);
extern Ast AstNewp (int type, const char *cursor, long line);


/** AstName
	Get name of a specified node type.
*/
extern String AstName (int type);


/** AstType
	These are the node types.
*/
#define AST_IN_HEADER
#define n_(name) N_##name,
enum
{
#include "Asts.h"
};
#undef n_
#undef AST_IN_HEADER


/***/
/*--------------------------------------------------------------------------*/

/* These are called internally by Class.c to initialize the Ast class. */
extern void AstSetup ();
extern void AstInit  ();

#endif /*_H_Ast_*/
