/* Boolean.h - Copyright (c) Marc Krisnanto */

#ifndef _H_Boolean_
#define _H_Boolean_ 1


/** Boolean
	The final Boolean class.
*/
extern Class BooleanClass;


/** True False
	These are the only two instances of the Boolean class.

	They are the keywords true and false in program level.
*/
extern Boolean True;
extern Boolean False;


/** BooleanIs
	Whether or not an object is a Boolean.

	@warn
	Watch for the macro side-effect.
*/
#define BooleanIs(x) ((Boolean) (x) == True || (Boolean) (x) == False)


/***/
/*--------------------------------------------------------------------------*/

/* These are called internally by Class.c to initialize the Boolean class. */
extern void BooleanSetup ();
extern void BooleanInit  ();


#endif /*_H_Boolean_*/
