/* Compile.h - Copyright (c) Marc Krisnanto */

#ifndef _H_Compile_
#define _H_Compile_ 1


/** CompileMAXLEVEL CompileMAXDEPTH CompileMAXARGS
	Some reasonable limits.

	CompileMAXLEVEL is the maximum number of nested blocks.

	CompileMAXDEPTH is the maximum number of nested expressions.

	CompileMAXARGS is the maximum number of arguments, items, etc.
	For one thing, it keeps a reasonable frame stack size.

	@warn
	CompileMAXLEVEL is tigthly related to ={Frame} objects. The bigger
	it is, the bigger the Frame object size is. It is generally a bad
	idea to change this setting.
*/
#define CompileMAXLEVEL 8
#define CompileMAXDEPTH 32
#define CompileMAXARGS  0xFFF


/** CompileIsCompiling
	To make sure that we don't accidentally call script functions while
	compiling. If we do, then there is something wrong with our logic.
*/
extern int volatile CompileIsCompiling;


/** CompileMain
	Compile the main program.

	Do not call this function directly.
	It is called by the main program ={qu}.c.
*/
extern Module CompileMain (String path);


/** CompileEval
	Compile an eval module.

	Do not call this function directly.
	It is designed for the interpreter.
	See C{interp.c}.
*/
extern Module CompileEval (Module m, int docstring);


/***/
/* This is called internally by qu.c to initialize the compiler. */
extern void CompileInit ();

#endif /*_H_Compile_*/
