/* Dlib.h - Copyright (c) Marc Krisnanto */

#ifndef _H_Dlib_
#define _H_Dlib_ 1


/** Dlib
	The final Dlib class.

	Dlib enables access to shared (dynamic) library functions and variables
	from within Qu programs.

	The internals are intentionally hidden since you should not be using Dlib
	from within C code.
*/
extern Class DlibClass;


/** TDlib
	This represents an instance of the Dlib class.
*/
struct TDlib
{
	OBJ_HEAD;
	void  *handle;  /* handle as returned by dlopen */
};


/** DlibIs
	Whether an object is a Dlib.
*/
#define DlibIs(x) (ClassOf (x) == DlibClass)


/***/
/*--------------------------------------------------------------------------*/

/* These are called internally by Class.c to initialize the Dlib class */
extern void DlibSetup ();
extern void DlibInit  ();

#endif /*_H_Dlib_*/
