/* Exceptions.h - Copyright (c) Marc Krisnanto */

/* --- designed to be included more than once */

#if defined(_EXCEPTION_HEADER)

#	undef _EXCEPTION_HEADER
#	ifdef _EXCEPTION_HEADER_USED
#		error *** invalid usage
#	else
#		define _EXCEPTION_HEADER_USED 1
#	endif
#	define s_(x, u, s) extern Class x##Class
#	define e_(x)       extern Class x##Class

#elif defined(_EXCEPTION_SOURCE_DECL)

#	undef _EXCEPTION_SOURCE_DECL
#	ifdef _EXCEPTION_SOURCE_DECL_USED
#		error *** invalid usage
#	else
#		define _EXCEPTION_SOURCE_DECL_USED 1
#	endif
#	define LASTERRNO EMEDIUMTYPE
#	define s_(x, u, s) Class x##Class = NULL
#	define e_(x)       Class x##Class = NULL

#elif defined(_EXCEPTION_SOURCE_INIT)

#	undef _EXCEPTION_SOURCE_INIT
#	ifdef _EXCEPTION_SOURCE_INIT_USED
#		error *** invalid usage
#	else
#		define _EXCEPTION_SOURCE_INIT_USED 1
#	endif
#	define s_(x, u, s) x##Class = ExceptionNewClass (SysModule, u##Class, #x, s)
#	define e_(x) \
		BEGIN \
			x##Class = ExceptionNewClass (SysModule, ESystemClass, #x, strerror (x)); \
			ErrnoClasses [x] = x##Class; \
		END
#endif

/** Exceptions
	Builtin exception classes.

	Append I{Class} to get the real symbol name, e.g. EStandardClass,
	EValueClass, EAGAINClass, etc.
*/
s_(EStandard                   , Exception   , "standard error");
    s_(ECompile                , EStandard   , "compile error");
        s_(ESyntax             , ECompile    , "syntax error");
        s_(EEos                , ECompile    , "unexpected end of source");
    s_(ERuntime                , EStandard   , "program error");
        s_(EAbstract           , ERuntime    , "object is abstract");
        s_(EAssert             , ERuntime    , "uncacthable failed assertion");
            s_(EProgram        , EAssert     , "catchable failed assertion");
        s_(ECall               , ERuntime    , "invalid call");
            s_(EArgCount       , ECall       , "bad number of arguments");
            s_(EArgValue       , ECall       , "invalid argument");
        s_(EData               , ERuntime    , "data error");
	        s_(EDatabase       , EData       , "database error");
	        s_(ECorrupt        , EData       , "corrupted data");
	        s_(ETransaction    , EData       , "transaction error");
	            s_(ECommit     , ETransaction, "commit error");
	            s_(EConflict   , ETransaction, "conflicting data");
	            s_(EUndo       , ETransaction, "undo operation failed");
        s_(EExit               , ERuntime    , "uncacthable exit");
            s_(EQuit           , EExit       , "cacthable exit");
        s_(EImplement          , ERuntime    , "not implemented");
        s_(EInterrupt          , ERuntime    , "keyboard interrupt");
        s_(EMemory             , ERuntime    , "out of memory");
        s_(EOverflow           , ERuntime    , "capacity overflow");
		s_(EPanic              , ERuntime    , "system in panic state");
        s_(ERecursion          , ERuntime    , "recursion limit exceeded");
        s_(ESecurity           , ERuntime    , "security error");
        s_(EStop               , ERuntime    , "stop iteration");
        s_(ETimeout            , ERuntime    , "operation timed out");
        s_(EThread             , ERuntime    , "thread error");
            s_(EDeadlock       , EThread     , "thread deadlock condition");
        s_(EValue              , ERuntime    , "invalid type or value");
            s_(EAssign         , EValue      , "object not assignable");
            s_(EEnum           , EValue      , "value not in enumeration");
            s_(EFormat         , EValue      , "format error");
            s_(EIndex          , EValue      , "invalid index");
                s_(EKey        , EIndex      , "no such key");
            s_(EMath           , EValue      , "math error");
                s_(EBrain      , EMath       , "unable to perform task");
                s_(ECmp        , EMath       , "objects not comparable");
                s_(EComplex    , EMath       , "result is a Complex");
                s_(EDiv        , EMath       , "invalid division");
                s_(EHuge       , EMath       , "result is too big");
                s_(EIand       , EMath       , "invalid bit-and operand");
                s_(EIdiv       , EMath       , "invalid integer division");
                s_(EIor        , EMath       , "invalid bit-or operand");
                s_(EInf        , EMath       , "result is infinity");
                s_(EIxor       , EMath       , "invalid bit-xor operand");
                s_(EMinus      , EMath       , "invalid subtraction");
                s_(EMul        , EMath       , "invalid multiplication");
                s_(EPlus       , EMath       , "invalid addition");
                s_(EPow        , EMath       , "invalid power");
                s_(ERem        , EMath       , "invalid remainder");
                s_(EShift      , EMath       , "invalid shift operand");
	                s_(ELshift , EShift      , "invalid left shift operand");
	                s_(ERshift , EShift      , "invalid right shift operand");
                s_(ETiny       , EMath       , "result is too small");
            s_(EModify         , EValue      , "can not modify object");
            s_(ENone           , EValue      , "no result");

s_(ESystem                     , Exception   , "system error");
    e_(EPERM);
    e_(ENOENT);
    e_(ESRCH);
    e_(EINTR);
    e_(EIO);
    e_(ENXIO);
    e_(E2BIG);
    e_(ENOEXEC);
    e_(EBADF);
    e_(ECHILD);
    e_(EAGAIN);
    e_(ENOMEM);
    e_(EACCES);
    e_(EFAULT);
    e_(ENOTBLK);
    e_(EBUSY);
    e_(EEXIST);
    e_(EXDEV);
    e_(ENODEV);
    e_(ENOTDIR);
    e_(EISDIR);
    e_(EINVAL);
    e_(ENFILE);
    e_(EMFILE);
    e_(ENOTTY);
    e_(ETXTBSY);
    e_(EFBIG);
    e_(ENOSPC);
    e_(ESPIPE);
    e_(EROFS);
    e_(EMLINK);
    e_(EPIPE);
    e_(EDOM);
    e_(ERANGE);
    e_(EDEADLK);
    e_(ENAMETOOLONG);
    e_(ENOLCK);
    e_(ENOSYS);
    e_(ENOTEMPTY);
    e_(ELOOP);
#if 0
#if EAGAIN != EWOULDBLOCK
    e_(EWOULDBLOCK);
#endif
#endif
    e_(ENOMSG);
    e_(EIDRM);
    e_(ECHRNG);
    e_(EL2NSYNC);
    e_(EL3HLT);
    e_(EL3RST);
    e_(ELNRNG);
    e_(EUNATCH);
    e_(ENOCSI);
    e_(EL2HLT);
    e_(EBADE);
    e_(EBADR);
    e_(EXFULL);
    e_(ENOANO);
    e_(EBADRQC);
    e_(EBADSLT);
#if 0
#if EDEADLOCK != EDEADLK
    e_(EDEADLOCK);
#endif
#endif
    e_(EBFONT);
    e_(ENOSTR);
    e_(ENODATA);
    e_(ETIME);
    e_(ENOSR);
    e_(ENONET);
    e_(ENOPKG);
    e_(EREMOTE);
    e_(ENOLINK);
    e_(EADV);
    e_(ESRMNT);
    e_(ECOMM);
    e_(EPROTO);
    e_(EMULTIHOP);
    e_(EDOTDOT);
    e_(EBADMSG);
    e_(EOVERFLOW);
    e_(ENOTUNIQ);
    e_(EBADFD);
    e_(EREMCHG);
    e_(ELIBACC);
    e_(ELIBBAD);
    e_(ELIBSCN);
    e_(ELIBMAX);
    e_(ELIBEXEC);
    e_(EILSEQ);
    e_(ERESTART);
    e_(ESTRPIPE);
    e_(EUSERS);
    e_(ENOTSOCK);
    e_(EDESTADDRREQ);
    e_(EMSGSIZE);
    e_(EPROTOTYPE);
    e_(ENOPROTOOPT);
    e_(EPROTONOSUPPORT);
    e_(ESOCKTNOSUPPORT);
    e_(EOPNOTSUPP);
    e_(EPFNOSUPPORT);
    e_(EAFNOSUPPORT);
    e_(EADDRINUSE);
    e_(EADDRNOTAVAIL);
    e_(ENETDOWN);
    e_(ENETUNREACH);
    e_(ENETRESET);
    e_(ECONNABORTED);
    e_(ECONNRESET);
    e_(ENOBUFS);
    e_(EISCONN);
    e_(ENOTCONN);
    e_(ESHUTDOWN);
    e_(ETOOMANYREFS);
    e_(ETIMEDOUT);
    e_(ECONNREFUSED);
    e_(EHOSTDOWN);
    e_(EHOSTUNREACH);
    e_(EALREADY);
    e_(EINPROGRESS);
    e_(ESTALE);
    e_(EUCLEAN);
    e_(ENOTNAM);
    e_(ENAVAIL);
    e_(EISNAM);
    e_(EREMOTEIO);
    e_(EDQUOT);
    e_(ENOMEDIUM);
    e_(EMEDIUMTYPE);

/***/
#undef s_
#undef e_
