/* Inlines.h - Copyright (c) Marc Krisnanto */

#ifndef _H_Inlines_
#define _H_Inlines_ 1


inline static Any iSys_as (Any self, Any x)
{
	Class c = ClassOf (self);

	if (c->accel && c->accel->fas)
		return c->accel->fas (self, x);
	return ObjectCall1 (self, A__as, x);
}



inline static Any iSys_clear (Any self)
{
	Class c;
	Any   x;

	c = ClassOf (self);
	if (c->accel && c->accel->fclear)
		x = c->accel->fclear (self);
	else
		x = ObjectCall0 (self, A__clear);

	ENSURE (x);
	if (self == x)
		return x;

	SysWARNRETVAL (self, "__clear", "self");
	THROW (EImplement);
}



inline static Int iSys_cmp (Any self, Any x)
{
	if (IntIs (self) && IntIs (x))
	{
		long u = IntTol (self);
		long v = IntTol (x);

		return (u < v) ? Int_1 : ((u > v) ? Int1 : Int0);
	}
	else
	{
		Class c = ClassOf (self);

		if (c->accel && c->accel->fcmp)
		{
			return c->accel->fcmp (self, x);
		}
		else
		{
			Any r = ObjectCall1 (self, A__cmp, x);

			if (r && IntIs (r))
				return r;

			SysWARNRETVAL (self, "__cmp", "Int");
			return ObjectDefaultCmpInt (self, x);
		}
	}
}



inline static String iSys_concat (Any self, Any x)
{
	return StringCat (Sys_string (self), Sys_string (x), NULL);
}



inline static Any iSys_copy (Any self)
{
	Class c;
	Any   x;

	c = ClassOf (self);
	if (c->accel && c->accel->fcopy)
		x = c->accel->fcopy (self);
	else
		x = ObjectCall0 (self, A__copy);

	ENSURE (x);
	if (ClassOf (x) == c)
		return x;

	SysWARNRETVAL (self, "__copy", c->name->str);
	THROW (EImplement);
}



inline static Int iSys_del (Any self, Any x)
{
	Class c;

	c = ClassOf (self);
	if (c->accel && c->accel->fdel)
		x = c->accel->fdel (self, x);
	else
		x = ObjectCall0 (self, A__del);

	ENSURE (x);
	if (IntIs (x))
		return x;

	SysWARNRETVAL (self, "__del", "Int");
	THROW (EImplement);
}



inline static Any iSys_decr (Any self)
{
	Class c;

	c = ClassOf (self);
	if (c->accel && c->accel->fdecr)
		return c->accel->fdecr (self);

	return ObjectCall0 (self, A__decr);
}



inline static Any iSys_div (Any self, Any x)
{
	Class c = ClassOf (self);

	if (c->accel && c->accel->fdiv)
		return c->accel->fdiv (self, x);

	return ObjectCall1 (self, A__div, x);
}



inline static Boolean iSys_eq (Any self, Any x)
{
	Class c = ClassOf (self);

	if (c->accel && c->accel->feq)
		return c->accel->feq (self, x);

	x = ObjectCall1 (self, A__eq, x);
	if (x == True || x == False)
		return x;

	SysWARNRETVAL (self, "__eq", "Boolean");
	return False;
}



inline static Any iSys_each (Any self)
{
	register Class c = ClassOf (self);

	if (c->accel)
	{
		if (c->accel->feach)
			return c->accel->feach (self);
	}
	else
	{
		register Any x = ObjectCall0 (self, A__each);
		if (x)
		{
			c = ClassOf (x);
			if (   c == StringClass
				|| c == ArrayClass
				|| c == DictClass
				|| c == ArgClass
				|| c == BufferClass
				|| c == SetClass
				|| c == FrameClass
				|| c == RangeClass
				|| c == IteratorClass
				|| c == RecordClass
				|| c == StructClass)
				return x;
		}
		SysWARNRETVAL (self, "__each", "valid iterator");
	}
	SysEIMPLEMENT (self, "__each");
}



inline static Any iSys_format (Any self, int argc, Any *argv)
{
	return Sys_format (self, argc, argv);
}



inline static Boolean iSys_ge (Any self, Any x)
{
	if (IntIs (self) && IntIs (x))
	{
		return ((long) self >= (long) x) ? True : False;
	}
	else
	{
		Class c = ClassOf (self);
		if (c->accel)
		{
			if (c->accel->fcmp)
			{
				x = c->accel->fcmp (self, x);
				return (x == Int0) ? True : ((long) x < 0) ? False : True;
			}
		}
		else
		{
			Any r = ObjectCall1 (self, A__cmp, x);

			if (r && IntIs (r))
				return (r == Int0) ? True : ((long) r < 0) ? False : True;

			SysWARNRETVAL (self, "__cmp", "Int");
		}
		return (ObjectDefaultCmp (self, x) >= 0) ? True : False;
	}
}



inline static int _iSys_attr_restrict (Any self, Frame f)
{
	if (self == f->self)
	{
		return 0;
	}
	else if (ModuleIs (self))
	{
		return ObjectModule (f->code->parent) != self;
	}
	else
	{
		Class c = ClassOf (self);
		Any   b;

		if (c == ClassClass)
			return 1;

		if (ClassIsAuto (c) || /* special case */ c == RecordClass)
			return 0;

		b = f->code->parent;

		if (SubIs (b)) /* && !SubIsInst (b)) */
		{
			Class k = SubClassOf (b);

			if (k)
			{
				if (c == k || ClassIsa (c, k))
					return 0;

				while (c)
				{
					if (c->mixin && ArrayContains (c->mixin, k))
						return 0;
					c = c->super;
				}
				return 0;
			}
		}
		return 1;
	}
}



inline static Any iSys_getattrx (Any self, String name, Frame f)
{
	return ClassOf (self)->get (self, name, _iSys_attr_restrict (self, f));
}



inline static Any iSys_getattr (Any self, Any x, Frame f)
{
	REQUIREZ (EValue, StringIs (x), "attribute name must be a String");
	return ClassOf (self)->get (self, x, _iSys_attr_restrict (self, f));
}



inline static Any iSys_getitem (Any self, Any x)
{
	Class c = ClassOf (self);
	if (c->accel)
	{
		if (c->accel->fgetitem)
			return c->accel->fgetitem (self, x);
	}
	return ObjectCall1 (self, A__getitem, x);
}



inline static Any iSys_getslice (Any self, Any i, Any len)
{
	Class c = ClassOf (self);
	if (c->accel)
	{
		if (c->accel->fgetslice)
			return c->accel->fgetslice (self, i, len);
	}
	return ObjectCall2 (self, A__getslice, i, len);
}



inline static Boolean iSys_gt (Any self, Any x)
{
	if (IntIs (self) && IntIs (x))
		return ((long) self > (long) x) ? True : False;
	else
	{
		Class c = ClassOf (self);
		if (c->accel)
		{
			if (c->accel->fcmp)
			{
				x = c->accel->fcmp (self, x);
				return (x == Int0) ? False : ((long) x < 0) ? False : True;
			}
		}
		else
		{
			Any r = ObjectCall1 (self, A__cmp, x);
			if (r && IntIs (r))
				return (r == Int0) ? False : ((long) r < 0) ? False : True;
			SysWARNRETVAL (self, "__cmp", "Int");
		}
		return (ObjectDefaultCmp (self, x) > 0) ? True : False;
	}
}



inline static Any iSys_iand (Any self, Any x)
{
	Class c = ClassOf (self);
	if (c->accel)
	{
		if (c->accel->fiand)
			return c->accel->fiand (self, x);
	}
	return ObjectCall1 (self, A__iand, x);
}



inline static Any iSys_idiv (Any self, Any x)
{
	Class c = ClassOf (self);
	if (c->accel)
	{
		if (c->accel->fidiv)
			return c->accel->fidiv (self, x);
	}
	return ObjectCall1 (self, A__idiv, x);
}



inline static Boolean iSys_in (Any self, Any x)
{
	Class c = ClassOf (self);

	if (c->accel)
	{
		if (c->accel->fin)
			return c->accel->fin (self, x);
	}
	x = ObjectCall1 (self, A__in, x);
	if (x)
	{
		if (BooleanIs (x))
			return x;
		SysWARNRETVAL (self, "__in", "Boolean");
	}
	SysEIMPLEMENT (self, "__in");
}



inline static Any iSys_incr (Any self)
{
	Class c = ClassOf (self);
	if (c->accel)
	{
		if (c->accel->fincr)
			return c->accel->fincr (self);
	}
	return ObjectCall0 (self, A__incr);
}



inline static Any iSys_inot (Any self)
{
	Class c = ClassOf (self);
	if (c->accel)
	{
		if (c->accel->finot)
			return c->accel->finot (self);
	}
	return ObjectCall0 (self, A__inot);
}



inline static Any iSys_ior (Any self, Any x)
{
	Class c = ClassOf (self);
	if (c->accel)
	{
		if (c->accel->fior)
			return c->accel->fior (self, x);
	}
	return ObjectCall1 (self, A__ior, x);
}


inline static Boolean iSys_is (Any self, Any x)
{
	if (RecordIs (self) && StructIs (x))
	{
		if (RecordOf (self, x))
			return True;
	}
	else if (StructIs (self) && StructIs (x))
	{
		if (self == x)
			return True;
	}
	else if (SubIs (x))
	{
		/* validator, e.g. _int_ */
		if (((Sub) x)->argc == 1 || ((Sub) x)->argc == -1 )
		{
			Any r = ObjectCallx1 (x, self);
			if (r == 0 || r == False)
				return False;
			return True;
		}
	}
	else if (MethodIs (x))
	{
		Any r = MethodCall1 (x, self);
		if (r == 0 || r == False)
			return False;
		return True;
	}
	else if (ModuleIs (x))
	{
		if (self == x)
			return True;
		else if (ModuleIs (self))
			return False;
		else
		{
			Class c = ClassOf (self);
			x = AttrFind (((Module) x)->attrs, c->name);
			if (x == (Any) c)
				return True;
		}
	}
	else
	{
		if (ObjectIsa (self, x))
			return True;
	}
	return False;
}



inline static Any iSys_ixor (Any self, Any x)
{
	Class c = ClassOf (self);
	if (c->accel)
	{
		if (c->accel->fixor)
			return c->accel->fixor (self, x);
	}
	return ObjectCall1 (self, A__ixor, x);
}



inline static Boolean iSys_le (Any self, Any x)
{
	if (IntIs (self) && IntIs (x))
		return ((long) self > (long) x) ? False : True;
	else
	{
		Class c = ClassOf (self);
		if (c->accel)
		{
			if (c->accel->fcmp)
			{
				x = c->accel->fcmp (self, x);
				return (x == Int0) ? True : ((long) x < 0) ? True : False;
			}
		}
		else
		{
			Any r = ObjectCall1 (self, A__cmp, x);
			if (r && IntIs (r))
				return (r == Int0) ? True : ((long) r < 0) ? True : False;
			SysWARNRETVAL (self, "__cmp", "Int");
		}
		return (ObjectDefaultCmp (self, x) <= 0) ? True : False;
	}
}



inline static Int iSys_len (Any self)
{
	Class c;
	Int   x;

	c = ClassOf (self);
	if (c->accel && c->accel->flen)
		x = c->accel->flen (self);
	else
		x = ObjectCall0 (self, A__len);

	ENSURE (x);
	if (IntIs (x))
		return x;

	SysWARNRETVAL (self, "__len", "Int");
	THROW (EImplement);
}



inline static Boolean iSys_like (Any self, Any x)
{
	Class c = ClassOf (self);
	Boolean  r;

	if (c->accel)
	{
		if (c->accel->flike)
			return c->accel->flike (self, x);
	}
	r = ObjectCall1 (self, A__like, x);
	if (r)
	{
		if (BooleanIs (r))
			return r;
		SysWARNRETVAL (self, "__like", "Boolean");
	}
	return False;
}



inline static Any iSys_lshift (Any self, Any x)
{
	Class c = ClassOf (self);
	if (c->accel)
	{
		if (c->accel->flshift)
			return c->accel->flshift (self, x);
	}
	return ObjectCall1 (self, A__lshift, x);
}



inline static Boolean iSys_lt (Any self, Any x)
{
	if (IntIs (self) && IntIs (x))
		return ((long) self >= (long) x) ? False : True;
	else
	{
		Class c = ClassOf (self);
		if (c->accel)
		{
			if (c->accel->fcmp)
			{
				x = c->accel->fcmp (self, x);
				return (x == Int0) ? False : ((long) x < 0) ? True : False;
			}
		}
		else
		{
			Any r = ObjectCall1 (self, A__cmp, x);
			if (r && IntIs (r))
				return (r == Int0) ? False : ((long) r < 0) ? True : False;
			SysWARNRETVAL (self, "__cmp", "Int");
		}
		return (ObjectDefaultCmp (self, x) < 0) ? True : False;
	}
}



inline static Any iSys_minus (Any self, Any x)
{
	if (IntIs (self) && IntIs (x))
	{
		register long r = IntTol (self) - IntTol (x);
		if (IntMIN <= r && r <= IntMAX)
			return IntNew (r);
		return LongNewl (r);
	}
	else
	{
		Class c = ClassOf (self);
		if (c->accel)
		{
			if (c->accel->fminus)
				return c->accel->fminus (self, x);
		}
		return ObjectCall1 (self, A__minus, x);
	}
}



inline static Any iSys_rem (Any self, Any x)
{
	Class c = ClassOf (self);
	if (c->accel)
	{
		if (c->accel->frem)
			return c->accel->frem (self, x);
	}
	return ObjectCall1 (self, A__rem, x);
}



inline static Any iSys_mul (Any self, Any x)
{
	Class c = ClassOf (self);

	if (c->accel)
	{
		if (c->accel->fmul)
			return c->accel->fmul (self, x);
	}
	return ObjectCall1 (self, A__mul, x);
}



inline static Boolean iSys_ne (Any self, Any x)
{
	if (self == x)
	{
		return False;
	}
	else
	{
		Class c = ClassOf (self);

		if (c->accel)
		{
			if (c->accel->feq)
				return c->accel->feq (self, x) == True ? False : True;
		}
		else
		{
			Boolean r = ObjectCall1 (self, A__eq, x);
			if (r)
			{
				if (BooleanIs (r))
					return r == True ? False : True;
			}
			SysWARNRETVAL (self, "__eq", "Boolean");
		}
	}
	return True;
}



inline static Any iSys_neg (Any self)
{
	Class c = ClassOf (self);
	if (c->accel)
	{
		if (c->accel->fneg)
			return c->accel->fneg (self);
	}
	return ObjectCall0 (self, A__neg);
}



inline static Boolean iSys_not (Any self)
{
	Class c = ClassOf (self);
	if (c->accel)
	{
		if (c->accel->ftrue)
			return (c->accel->ftrue (self) == True) ? False : True;
	}
	else
	{
		Boolean x = ObjectCall0 (self, A__true);
		if (x == True)
			return False;
		if (x == False)
			return True;
		SysWARNRETVAL (self, "__true", "Boolean");
	}
	return False;
}



inline static Any iSys_of (Any self, Any x)
{
	Class c = ClassOf (self);

	if (c->accel)
	{
		if (c->accel->fof)
			return c->accel->fof (self, x);
	}
	return ObjectCall1 (self, A__of, x);
}



inline static Any iSys_plus (Any self, Any x)
{
	if (IntIs (self) && IntIs (x))
	{
		register long r = IntTol (self) + IntTol (x);
		if (IntMIN <= r && r <= IntMAX)
			return IntNew (r);
		return LongNewl (r);
	}
	else
	{
		Class c = ClassOf (self);
		if (c->accel && c->accel->fplus)
			return c->accel->fplus (self, x);
		return ObjectCall1 (self, A__plus, x);
	}
}



inline static Any iSys_pop (Any self)
{
	Class c = ClassOf (self);
	if (c->accel)
	{
		if (c->accel->fpop)
			return c->accel->fpop (self);
	}
	return ObjectCall0 (self, A__pop);
}



inline static Any iSys_pos (Any self)
{
	Class c = ClassOf (self);
	if (c->accel)
	{
		if (c->accel->fpos)
			return c->accel->fpos (self);
	}
	return ObjectCall0 (self, A__pos);
}



inline static Any iSys_pow (Any self, Any x)
{
	Class c = ClassOf (self);

	if (c->accel)
	{
		if (c->accel->fpow)
			return c->accel->fpow (self, x);
	}
	return ObjectCall1 (self, A__pow, x);
}



inline static Any iSys_push (Any self, Any x)
{
	Class c = ClassOf (self);
	if (c->accel)
	{
		if (c->accel->fpush)
			return c->accel->fpush (self, x);
	}
	return ObjectCall1 (self, A__push, x);
}



inline static Any iSys_range (Any self, Any x)
{
	REQUIRE (EValue, IntIs (self) && IntIs (x));
	return RangeNewEx (self, x);
}



inline static Any iSys_ratio (Any self, Any x)
{
	return RationalNewRatio (self, x);
}



inline static Boolean iSys_rin (Any x, Any self)
{
	Class c = ClassOf (self);

	if (c->accel)
	{
		if (c->accel->fin)
			return c->accel->fin (self, x);
	}
	x = ObjectCall1 (self, A__in, x);
	if (x)
	{
		if (BooleanIs (x))
			return x;
		SysWARNRETVAL (self, "__in", "Boolean");
	}
	SysEIMPLEMENT (self, "__in");
}



inline static Any iSys_rshift (Any self, Any x)
{
	Class c = ClassOf (self);

	if (c->accel)
	{
		if (c->accel->frshift)
			return c->accel->frshift (self, x);
	}
	return ObjectCall1 (self, A__rshift, x);
}



inline static Any iSys_setitem (Any self, Any x, Any v)
{
	Class c = ClassOf (self);
	if (c->accel)
	{
		if (c->accel->fsetitem)
			return c->accel->fsetitem (self, x, v);
	}
	return ObjectCall2 (self, A__setitem, x, v);
}



inline static Any iSys_setslice (Any self, Any from, Any len, Any v)
{
	Class c = ClassOf (self);
	if (c->accel)
	{
		if (c->accel->fsetslice)
			return c->accel->fsetslice (self, from, len, v);
	}
	return ObjectCall3 (self, A__setslice, from, len, v);
}



inline static Any iSys_setattrx (Any self, String name, Any val, Frame f)
{
	return ClassOf (self)->set (self, name, val, _iSys_attr_restrict (self, f));
}



inline static Any iSys_setattr (Any self, Any x, Any val, Frame f)
{
	REQUIREZ (EValue, StringIs (x), "attribute name must be a String");
	return ClassOf (self)->set (self, x, val, _iSys_attr_restrict (self, f));
}



inline static String iSys_string (Any self)
{
	Class c = ClassOf (self);
	if (c->accel)
	{
		if (c->accel->fstring)
			return c->accel->fstring (self);
	}
	else
	{
		Any x = ObjectCall0 (self, A__string);
		if (x)
		{
			if (StringIs (x))
				return x;
		}
		SysWARNRETVAL (self, "__string", "String");
	}
	return ObjectDefaultString (self);
}



inline static Boolean iSys_true (Any self)
{
	Class c = ClassOf (self);
	if (c->accel)
	{
		if (c->accel->ftrue)
			return c->accel->ftrue (self);
	}
	else
	{
		Boolean x = ObjectCall0 (self, A__true);
		if (x == True || x == False)
			return x;
		SysWARNRETVAL (self, "__true", "Boolean");
	}
	return True;
}



inline static Any iSys_xplus (int argc, Any *argv)
{
	Any r;
	assert (argc > 0);
	r = *argv++;
	while (--argc && r)
	{
		r = iSys_plus (r, *argv++);
	}
	return r;
}



inline static Any iSys_xminus (int argc, Any *argv)
{
	Any r;
	assert (argc > 0);
	r = *argv++;
	while (--argc && r)
	{
		r = iSys_minus (r, *argv++);
	}
	return r;
}



inline static Any iSys_xdiv (int argc, Any *argv)
{
	Any r;
	assert (argc > 0);
	r = *argv++;
	while (--argc && r)
	{
		r = iSys_div (r, *argv++);
	}
	return r;
}


inline static Any iSys_xmul (int argc, Any *argv)
{
	Any r;
	assert (argc > 0);
	r = *argv++;
	while (--argc && r)
	{
		r = Sys_mul (r, *argv++);
	}
	return r;
}



inline static Any iSys_xrem (int argc, Any *argv)
{
	Any r;

	assert (argc > 0);
	r = *argv++;
	while (--argc && r)
	{
		r = iSys_rem (r, *argv++);
	}
	return r;
}



inline static String iSys_xcat (int argc, Any *argv)
{
	return Sys_syscat (argc, argv);
}



inline static Boolean iSys_xeq (int argc, Any *argv)
{
	Any r;

	assert (argc > 0);
	r = *argv++;
	while (--argc)
	{
		if (iSys_eq (r, *argv++) != True)
			return False;
	}
	return True;
}



inline static Boolean iSys_xne (int argc, Any *argv)
{
	Any r;
	assert (argc > 0);
	r = *argv++;
	while (--argc)
	{
		if (iSys_ne (r, *argv++) != True)
			return False;
	}
	return True;
}



inline static Boolean iSys_xlike (int argc, Any *argv)
{
	Any r;
	assert (argc > 0);
	r = *argv++;
	while (--argc)
	{
		if (iSys_like (r, *argv++) != True)
			return False;
	}
	return True;
}



inline static Any iSys_xixor (int argc, Any *argv)
{
	Any r;
	assert (argc > 0);
	r = *argv++;
	while (--argc && r)
	{
		r = iSys_ixor (r, *argv++);
	}
	return r;
}



inline static Any iSys_xiand (int argc, Any *argv)
{
	Any r;
	assert (argc > 0);
	r = *argv++;
	while (--argc && r)
	{
		r = iSys_iand (r, *argv++);
	}
	return r;
}



inline static Any iSys_xior (int argc, Any *argv)
{
	Any r;
	assert (argc > 0);
	r = *argv++;
	while (--argc && r)
	{
		r = iSys_ior (r, *argv++);
	}
	return r;
}


#endif /*_H_Inlines_*/
