/* Method.h - Copyright (c) Marc Krisnanto */

#ifndef _H_Method_
#define _H_Method_ 1


/** Method
	This is the final Method class.

	A Method is a ={Sub} which is bound to a self value. Calling means
	calling the Sub object passing the self object bound to it.
*/
extern Class MethodClass;


/** TMethod
	This represents an instance of the Method class.
*/
struct TMethod
{
	OBJ_HEAD;
	Sub   sub;    /* the Sub object */
	Any   self;   /* the 'self' */
	Array args;   /* arguments before formal arguments, initially 0 */
};


/** MethodIs
	Whether or not the object is a Method.
*/
#define MethodIs(o) (ClassOf(o) == MethodClass)


/** MethodFlag
	Flags used by Method objects.

	Do not access these flags directly.
	Use the provided accessor macros instead.
*/
#define MethodFlagDELEGATE  Flag0  /* got it from __get */
#define MethodFlagSETSELF   Flag1  /* must set self on call? */


/** MethodIsDELEGATE
	Whether the method was created by __get.
	This is to support delegation.

	@warn
	Do not use this. It is for Object.c.
*/
#define MethodIsDelegate(self)   FlagTest (self, MethodFlagDELEGATE)
#define MethodSetDelegate(self)  FlagSet  (self, MethodFlagDELEGATE)


/** MethodNew
	Create a new Method.
*/
extern Method MethodNew (Sub sub, Any self);


/** MethodModule
	Get the ={Module} object where the Method is declared.
*/
extern Module MethodModule (Method self);


/** MethodClassOf
	Get the ={Class} object where the Method is declared.
*/
extern Class MethodClassOf (Method self);


/** MethodCall
	Call a method.
*/
extern Any MethodCalln (Method self, int argc, Any *argv);
extern Any MethodCall4 (Method self, Any a1, Any a2, Any a3, Any a4);
extern Any MethodCall3 (Method self, Any a1, Any a2, Any a3);
extern Any MethodCall2 (Method self, Any a1, Any a2);
extern Any MethodCall1 (Method self, Any a1);
extern Any MethodCall0 (Method self);


/***/
/*--------------------------------------------------------------------------*/

/* These are called internally by Class.c to initialize the Method class */
extern void MethodSetup (void);
extern void MethodInit  (void);

/* EXPERIMENTAL - currying - for Reduce.c */
extern Method MethodCurryCompileTime (Any sub, Ast list);

/* for interp.c */
extern Any MethodCallnAttr (Method self, Any theself, int argc, Any *argv);

#endif /*_H_Method_*/
