/* Pointer.h - Copyright (c) Marc Krisnanto */

#ifndef _H_Pointer_
#define _H_Pointer_ 1


/** Pointer
	The final Pointer class.
*/
extern Class PointerClass;


/** TPointer
	This represents an instance of the Pointer class.
*/
struct TPointer
{
	OBJ_HEAD;
	long   size;  /* content length \                       */
	long   dummy; /* not used        >-- must match TString */
	void  *ptr;   /* the pointer    /                       */
	long   delta; /* incremental */
	Any    spec;  /* C struct specification: 0 or String or Struct or Dict */
};


/** PointerFlag
	Flags used by Pointer objects.
*/
#define PointerALLOCATED Flag0  /* if is was allocated */
#define PointerSYSMALLOC Flag1  /* allocated with malloc */


/** PointerIs
	Whether or not the object is a Pointer.
*/
#define PointerIs(o) (ClassOf (o) == PointerClass)


/** PointerNULL
	The NULL pointer.
*/
extern Pointer PointerNULL;


/** PointerNew
	Create a new Pointer object.

	With PointerNewMalloc, v{m} must be a GcMemMalloc'ed memory address.
	With PointerNew, v{m} is any arbitrary memory address.
*/
extern Pointer PointerNew       (void *p);
extern Pointer PointerNewMalloc (void *m, long size);


/** PointerGet PointerSet
	Set or get value.

	See ${Struct.spec} for valid types.
*/
extern Any PointerGet (void *p, char type);
extern int PointerSet (void *p, char type, Any x);


/***/
/*--------------------------------------------------------------------------*/

/* These are called internally by Class.c to initialize the Pointer class. */
extern void PointerSetup ();
extern void PointerInit  ();

#endif /*_H_Pointer_*/
