/* Proc.h - Copyright (c) Marc Krisnanto */

#ifndef _H_Proc_
#define _H_Proc_ 1


/** Proc
	The final Proc class.

	@warn
	The Proc class needs GNU Lightning.
*/
extern Class ProcClass;


/** TProc
	This represents an instance of the Proc class.
*/
struct TProc
{
	OBJ_HEAD;
	char *code; /* (jit_insn *) the C code interface - GcMemMalloc'ed */
	Sub   sub;  /* the Q Sub to call */
};


/** ProcFlag
	Flags used by Proc objects.
*/
/* all reserved */


/** ProcIs
	Wwhether the object is a Proc.
*/
#define ProcIs(o) (ClassOf (o) == ProcClass)


/***/
/*--------------------------------------------------------------------------*/

/* These are called internally by Class.c to initialize the Proc class. */
extern void ProcSetup ();
extern void ProcInit  ();

#endif /*_H_Proc_*/
