/* Range.h - Copyright (c) Marc Krisnanto */

#ifndef _H_Range_
#define _H_Range_ 1


/** Range
	This is the final Range class.
*/
extern Class RangeClass;


/** TRange
	This represents an instance of the Range class.

	@warn
	All fields must be in the ={Int} class range.
*/
struct TRange
{
	OBJ_HEAD;
	long first; /* start of range */
	long last;  /* end of range */
	long step;  /* delta */
	long count; /* number of items (pre-calculated by Range.c) */
};


/** RangeIs
	Whether or not an object is a Range.

	Always use this macro to test whether or not an object is a Range.
	In the future, if we ever decide to let the Range class be suclassed then the
	macro will change to C{ObjectInstOf (o, Range)}.
*/
#define RangeIs(o) (ClassOf(o) == RangeClass)


/** RangeNew
	Create a new Range object.

	Make sure the arguments are in the Int range and does not produce a count
	more than ={GC_MAX_SIZE} otherwise you get an EArgValue.
*/
extern Range RangeNew   (long first, long last, long step);
extern Range RangeNewEx (Any first, Any last);


/** RangeCover
	Get the starting index in a container and the number of items covered
	by the range. See C{Array.__getitem} for an example.
*/
extern long RangeCover (Range self, long len, long *start);


/** RangeContains
	Whether or not v{x} is within the Range.
	If v{x} is not an object then returns 0.
*/
extern int RangeContains (Range self, Any x);


/** RangeEq
	Whether or not a Range has the same property fields as another.
*/
extern int RangeEq (Range self, Range x);



/***/
/*--------------------------------------------------------------------------*/

/* These are called internally by Class.c to initialize the Range class. */
extern void RangeSetup ();
extern void RangeInit  ();

#endif /*_H_Range_*/
