/* Tokens.h - Copyright (c) Marc Krisnanto */

/* --- designed to be included more than once */

/** Tokens
	List of tokens.
*/
#ifdef TOKENIZER_IN_HEADER
t_(DONT_USE , "*?*")
#endif
#ifndef TOKENIZER_IN_INIT
t_(NAME     , "NAME")
t_(INT      , "INT")
t_(FLOAT    , "FLOAT")
t_(BIG      , "BIG")
t_(STRING   , "STRING")
t_(TEXT     , "TEXT")
t_(HTML     , "HTML")
t_(FIELD    , "FIELD")
t_(DOC      , "DOC")
t_(LONG     , "LONG")
t_(RATIONAL , "RATIONAL")
t_(INF      , "INF")
t_(COMPLEX  , "COMPLEX")
t_(INDENT   , "INDENT")
t_(DEDENT   , "DEDENT")

t_(HTMLOPEN        , "HTMLOPEN")
t_(HTMLOPENCLOSE   , "HTMLOPENCLOSE")
t_(HTMLOPENCLOSEBR , "HTMLOPENCLOSEBR")
t_(HTMLCLOSE       , "HTMLCLOSE")
t_(HTMLCLOSEBR     , "HTMLCLOSEBR")
t_(HTMLENTITY      , "HTMLENTITY")

#endif
t_(LCURLY    , "{")
t_(RCURLY    , "}")
t_(LSQUARE   , "[")
t_(RSQUARE   , "]")
t_(LPAREN    , "(")
t_(LPRINT    , "(.")
t_(LPRINTHTML, "(\\")
t_(RPAREN    , ")")

t_(COMMA    , ",")
t_(QUEST    , "?")
t_(BITNOT   , "~")
t_(AT       , "@")
t_(DOLLAR   , "$")

t_(REM      , "%")
t_(FORMAT   , "%%")
t_(ASREM    , "%=")

t_(DOT      , ".")
t_(DOT2     , "..")
t_(DOT3     , "...")

t_(SEMI     , ";")
t_(END      , ";;")

t_(COLON    , ":")
t_(COLON2   , "::")
t_(ASCOLON  , ":=")

t_(ASSIGN   , "=")
t_(EQ       , "==")
t_(LIKE     , "===")

t_(NOT      , "!")
t_(NE       , "!=")

t_(LT       , "<")
t_(CONTRA   , "<>")
t_(LSHIFT   , "<<")
t_(ASLSHIFT , "<<=")
t_(LE       , "<=")
t_(CMP      , "<=>")
t_(XCHG     , "<->")
t_(PUSH     , "<<<")

t_(GT       , ">")
t_(GE       , ">=")
t_(RSHIFT   , ">>")
t_(ASRSHIFT , ">>=")
t_(POP      , ">>>")

t_(BITAND   , "&")
t_(ASBITAND , "&=")
t_(AND      , "&&")
t_(ASAND    , "&&=")

t_(BITOR    , "|")
t_(ASBITOR  , "|=")
t_(OR       , "||")
t_(ASOR     , "||=")

t_(PLUS     , "+")
t_(INCR     , "++")
t_(ASPLUS   , "+=")

t_(MINUS    , "-")
t_(DECR     , "--")
t_(TAG      , "---")
t_(ASMINUS  , "-=")
t_(ARROW    , "->")

t_(CONCAT   , "_")
t_(ASCONCAT , "_=")
t_(RATIO    , "_/")

t_(MUL      , "*")
t_(POW      , "**")
t_(ASMUL    , "*=")

t_(DIV      , "/")
t_(ASDIV    , "/=")

t_(IDIV     , "\\")
t_(ASIDIV   , "\\=")

t_(BITXOR   , "^")
t_(ASBITXOR , "^=")

t_(as       , "as")
t_(do       , "do")
t_(if       , "if")
t_(in       , "in")
t_(is       , "is")
t_(me       , "me")
t_(of       , "of")
t_(or       , "or")

t_(and      , "and")
t_(are      , "are")
t_(end      , "end")
t_(for      , "for")
t_(nil      , "nil")
t_(not      , "not")
t_(sub      , "sub")
t_(try      , "try")
t_(use      , "use")
t_(var      , "var")
t_(xor      , "xor")

t_(case     , "case")
t_(each     , "each")
t_(elif     , "elif")
t_(else     , "else")
t_(enum     , "enum")
t_(infp     , "infp")
t_(infn     , "infn")
t_(loop     , "loop")
t_(null     , "null")
t_(pass     , "pass")
t_(redo     , "redo")
t_(self     , "self")
t_(true     , "true")
t_(with     , "with")

t_(alias    , "alias")
t_(break    , "break")
t_(catch    , "catch")
t_(class    , "class")
t_(const    , "const")
t_(false    , "false")
t_(local    , "local")
t_(super    , "super")
t_(throw    , "throw")
t_(until    , "until")
t_(while    , "while")
t_(yield    , "yield")

t_(assert   , "assert")
t_(atomic   , "atomic")
t_(ensure   , "ensure")
t_(import   , "import")
t_(lambda   , "lambda")
t_(pragma   , "pragma")
t_(return   , "return")
t_(static   , "static")
t_(struct   , "struct")
t_(switch   , "switch")
t_(unless   , "unless")

t_(default  , "default")
t_(finally  , "finally")
t_(_end     , "__end__")
t_(_doc     , "__doc__")

t_(continue , "continue")
t_(_argc    , "__argc__")
t_(_line    , "__line__")
t_(_file    , "__file__")
t_(_here    , "__here__")
t_(_swap    , "__swap__")
t_(_test    , "__test__")

t_(_frame   , "__frame__")


/* tags */
t_(_abstract    , "__abstract")
t_(_accumulator , "__accumulator")
t_(_args        , "__args")
t_(_auto        , "__auto")
t_(_final       , "__final")
t_(_generator   , "__generator")
t_(_interface   , "__interface")
t_(_mixin       , "__mixin")
t_(_once        , "__once")
t_(_package     , "__package")
t_(_public      , "__public")
t_(_pure        , "__pure")
t_(_private     , "__private")
t_(_readwrite   , "__readwrite")
t_(_readonly    , "__readonly")
t_(_uncatchable , "__uncatchable")
t_(_unsafe      , "__unsafe")

/***/
