/* Utf8.h - Copyright (c) Marc Krisnanto */

#ifndef _H_Utf8_
#define _H_Utf8_ 1


/** WCHAR_INVALID
	The invalid wide character.
*/
#define WCHAR_INVALID ((wint_t) -1)


/** Utf8CharLen
	Return the number of bytes needed to encode a wide character.
*/
extern int Utf8CharLen (wint_t c);


/** Utf8PutChar
	Encode one wide charater and return the updated pointer.

	@warn
	Make sure there is enough room.
*/
extern char *Utf8PutChar (char *s, wint_t c);


/** Utf8GetChar
	Get a wide character and update the pointer.
	Return -1 if the wide character is invalid.
*/
extern wint_t Utf8GetChar (char **s, char *end);


/** Utf8ReadChar
	Get a wide character.

	@warn
	This function assumes a valid pointer and valid UTF-8 string.
*/
extern wint_t Utf8Charat (char *s);


/** Utf8New
	Creates a new String from raw bytes.
	Throw ESyntax if the bytes are not valid UTF-8 multibytes.
*/
extern String Utf8New (const char *z, long len);


/** Utf8NewChar
	Allocate a single UTF-8 character string.
*/
extern String Utf8NewChar (wint_t c);


/** Utf8Width
	Count the number of wide characters in the string.
	Return -1 if the string is not a valid UTF-8 string.
*/
extern long Utf8Width (const char *z, long l);


/** Utf8Pos
	Get the position of the v{i}-th character, v{i} may be negative
	Return NULL if not found.
*/
extern char *Utf8Pos (const char *z, long l, long i);


/** Utf8Last
	Get the position of the last character.
	Return NULL if the v{l} is non-positive.

	@warn
		This function assumes a valid UTF-8 string.
*/
extern char *Utf8Last (const char *z, long l);


/** Utf8GetItem
	Return a String of the v{i}-th character, v{i} may be negative.
*/
extern String Utf8GetItem (String self, long i);


/** Utf8GetSlice
	Get a slice of the string starting at the v{i}-th character, v{n} characters
	long, v{i} may be negative.
*/
extern String Utf8GetSlice (String self, long i, long n);


/** Utf8Tests
	Character tests.
*/
extern int Utf8Isalpha  (wint_t c);
extern int Utf8Isalnum  (wint_t c);
extern int Utf8Isblank  (wint_t c);
extern int Utf8Iscntrl  (wint_t c);
extern int Utf8Isdigit  (wint_t c);
extern int Utf8Isxdigit (wint_t c);
extern int Utf8Isgraph  (wint_t c);
extern int Utf8Islower  (wint_t c);
extern int Utf8Isprint  (wint_t c);
extern int Utf8Ispunct  (wint_t c);
extern int Utf8Isspace  (wint_t c);
extern int Utf8Isupper  (wint_t c);
extern int Utf8Iswide   (wint_t c);


/** Utf8Conversion
	Conversion functions.
*/
extern wint_t Utf8Toupper (wint_t c);
extern wint_t Utf8Tolower (wint_t c);
extern wint_t Utf8Totitle (wint_t c);


/***/
#endif /*_H_Utf8_*/
