/* Weak.h - Copyright (c) Marc Krisnanto */

#ifdef QU_WITH_WEAK

#ifndef _H_Weak_
#define _H_Weak_ 1


/** Weak
	This is the final Weak class.
*/
extern Class WeakClass;


/** TWeak
	This represents an instance of the Weak class.
*/
struct TWeak
{
	OBJ_HEAD;
	Obj  ref;  /* the referenced object, maybe 0 */
	long hash; /* the object hash value */
};


/** WeakFlag
	Flags used by Weak objects.
*/
/* none but reserve all */


/** WeakIs
	Whether or not the object is a Weak.
*/
#define WeakIs(o) (ClassOf(o) == WeakClass)


/***/
/*--------------------------------------------------------------------------*/

/* These are called internally by Class.c to initialize the Weak class */
extern void WeakSetup ();
extern void WeakInit  ();

/* for Gc.c and Weak.c */
#define WeakUNREF(self) BEGIN ((self)->ref) = NULL; END


#endif /*_H_Weak_*/

#else /*QU_WITH_WEAK*/

extern int Weak_is_not_here ();

#endif /*QU_WITH_WEAK*/
