/* ascii.h - Copyright (c) Marc Krisnanto */

#ifndef _H_ascii_
#define _H_ascii_ 1

#include "base.h"

/** AsciiTable
	Various ASCII character tables.
*/
extern unsigned char AsciiTOLOWER [256];
extern unsigned char AsciiTOUPPER [256];
extern unsigned char AsciiTOPRINT [256];
extern unsigned char AsciiTOTEXT  [256];
extern unsigned char AsciiTOTITLE [256];
extern unsigned char AsciiISLOWER [256];
extern unsigned char AsciiISUPPER [256];
extern unsigned char AsciiISALPHA [256];
extern unsigned char AsciiISDIGIT [256];
extern unsigned char AsciiISALNUM [256];
extern unsigned char AsciiISIDENT [256];
extern unsigned char AsciiISIDNUM [256];
extern unsigned char AsciiISXDIGIT[256];
extern unsigned char AsciiISODIGIT[256];
extern unsigned char AsciiISBDIGIT[256];
extern unsigned char AsciiISSPACE [256];
extern unsigned char AsciiISBLANK [256];
extern unsigned char AsciiISWHITE [256];
extern unsigned char AsciiISWORD  [256];
extern unsigned char AsciiISPWD   [256];
extern unsigned char AsciiISNAME  [256];
extern unsigned char AsciiISCNTRL [256];
extern unsigned char AsciiISPUNCT [256];
extern unsigned char AsciiISGRAPH [256];
extern unsigned char AsciiISPRINT [256];
extern unsigned char AsciiISTEXT  [256];
extern unsigned char AsciiISPATH  [256];
extern unsigned char AsciiHEXVAL  [256];
extern unsigned char AsciiTOIDENT [256];
extern unsigned char AsciiSWAPCASE[256];


/** AsciiDIGIT
	All digits.
*/
extern char AsciiDIGITL[36]; /* 0123456789abcdefghijklmnopqrstuvwxyz */
extern char AsciiDIGITU[36]; /* 0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ */


/** AsciiHexval
	Returns the hex value of a character, -1 if the character is not
	a valid hexadecimal character.
*/
#define AsciiHexval(c)  (AsciiHEXVAL [255 & (c)])


/** AsciiTo
	Convert an ASCII character.

	All macros are designed with no side-effect.
*/
#define AsciiToLower(c)  ((char) AsciiTOLOWER [255 & (c)])
#define AsciiToUpper(c)  ((char) AsciiTOUPPER [255 & (c)])
#define AsciiToTitle(c)  ((char) AsciiTOTITLE [255 & (c)])
#define AsciiToPrint(c)  ((char) AsciiTOPRINT [255 & (c)])
#define AsciiToText(c)   ((char) AsciiTOTEXT  [255 & (c)])
#define AsciiToIdent(c)  ((char) AsciiTOIDENT [255 & (c)])
#define AsciiSwapCase(c) ((char) AsciiSWAPCASE[255 & (c)])


/** AsciiIs
	Test an ASCII character.

	All macros are designed with no side-effect.
*/
#define AsciiIsLower(c)  (AsciiISLOWER [255 & (c)])
#define AsciiIsUpper(c)  (AsciiISUPPER [255 & (c)])
#define AsciiIsAlpha(c)  (AsciiISALPHA [255 & (c)])
#define AsciiIsDigit(c)  (AsciiISDIGIT [255 & (c)])
#define AsciiIsAlnum(c)  (AsciiISALNUM [255 & (c)])
#define AsciiIsXdigit(c) (AsciiISXDIGIT[255 & (c)])
#define AsciiIsSpace(c)  (AsciiISSPACE [255 & (c)])
#define AsciiIsBlank(c)  (AsciiISBLANK [255 & (c)])
#define AsciiIsCntrl(c)  (AsciiISCNTRL [255 & (c)])
#define AsciiIsPunct(c)  (AsciiISPUNCT [255 & (c)])
#define AsciiIsGraph(c)  (AsciiISGRAPH [255 & (c)])
#define AsciiIsPrint(c)  (AsciiISPRINT [255 & (c)])
#define AsciiIsText(c)   (AsciiISTEXT  [255 & (c)])
#define AsciiIsIdent(c)  (AsciiISIDENT [255 & (c)])
#define AsciiIsIdnum(c)  (AsciiISIDNUM [255 & (c)])
#define AsciiIsOdigit(c) (AsciiISODIGIT[255 & (c)])
#define AsciiIsWhite(c)  (AsciiISWHITE [255 & (c)])
#define AsciiIsWord(c)   (AsciiISWORD  [255 & (c)])
#define AsciiIsPwd(c)    (AsciiISPWD   [255 & (c)])
#define AsciiIsName(c)   (AsciiISNAME  [255 & (c)])
#define AsciiIsPath(c)   (AsciiISPATH  [255 & (c)])

/***/
#endif /*_H_ascii_*/
