/* attrs.h - Copyright (c) Marc Krisnanto */

/* --- designed to be included more than once */

#if defined(_ATTRS_HEADER)

#	undef _ATTRS_HEADER
#	ifdef _ATTRS_HEADER_USED
#		error *** invalid usage
#	else
#		define _ATTRS_HEADER_USED 1
#	endif
#	define a_(name) extern String A_##name
#	define u_(name) extern String A_##name

#elif defined(_ATTRS_SOURCE_DECL)

#	undef _ATTRS_SOURCE_DECL
#	ifdef _ATTRS_SOURCE_DECL_USED
#		error *** invalid usage
#	else
#		define _ATTRS_SOURCE_DECL_USED 1
#	endif
#	define a_(name) String A_##name
#	define u_(name) String A_##name

#elif defined(_ATTRS_SOURCE_INIT)

#	undef _ATTRS_SOURCE_INIT
#	ifdef _ATTRS_SOURCE_INIT_USED
#		error *** invalid usage
#	else
#		define _ATTRS_SOURCE_INIT_USED 1
#	endif
#	define a_(name) A_##name = StringStaticz (#name)
#	define u_(name) A_##name = StringStaticz ("_"#name)

#endif


/** A_xxx
	List of standard attribute names. All are predefined ={String} objects
	created by ={Class} at initialization time.

	To get the real symbol name, prepend C{A_} to the v{a_} macros and
	C{A__} to the v{u_} macros.

	@xmp
		A_new   -> "new"
		A__plus -> "__plus"
*/
a_(classof);
a_(flags);
a_(ident);
a_(name);
a_(new);

u_(_attrs);
u_(_args);
u_(_block);
u_(_code);
u_(_decl);
u_(_defines);
u_(_doc);
u_(_flags);
u_(_ident);
u_(_isa);
u_(_isabstract);
u_(_isauto);
u_(_isextern);
u_(_isfinal);
u_(_ismixin);
u_(_isprivate);
u_(_issuper);
u_(_master);
u_(_mixes);
u_(_mixins);
u_(_module);
u_(_name);
u_(_rank);
u_(_root);
u_(_storable);
u_(_super);
u_(_tree);
u_(_where);

u_(_as);
u_(_call);
u_(_class);
u_(_clear);
u_(_cmp);
u_(_copy);
u_(_decr);
u_(_del);
u_(_destroy);
u_(_div);
u_(_each);
u_(_eq);
u_(_format);
u_(_get);
u_(_getitem);
u_(_getslice);
u_(_hash);
u_(_iand);
u_(_id);
u_(_idiv);
u_(_in);
u_(_incr);
u_(_init);
u_(_inot);
u_(_inst);
u_(_iterable);
u_(_ior);
u_(_ixor);
u_(_len);
u_(_like);
u_(_load);
u_(_lshift);
u_(_minus);
u_(_mul);
u_(_neg);
u_(_next);
u_(_not);
u_(_of);
u_(_plus);
u_(_pop);
u_(_pos);
u_(_pow);
u_(_print);
u_(_push);
u_(_rem);
u_(_set);
u_(_setitem);
u_(_setslice);
u_(_stop);
u_(_store);
u_(_string);
u_(_rshift);
u_(_tag);
u_(_true);
u_(_typeof);
u_(_version);
u_(_weak);


/***/
#undef a_
#undef u_
