/* base.h - Copyright (c) Marc Krisnanto */

#ifndef _H_base_
#define _H_base_ 1

#include "../config.h"


/** Libraries
	These are the C libraries included by C{base.h}.
*/
#undef NDEBUG
#ifndef DEBUG
#define NDEBUG
#endif
#include <assert.h>
#include <ctype.h>
#include <limits.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <stddef.h>
#include <string.h>
#include <locale.h>
#include <errno.h>
#include <float.h>
#include <math.h>
#include <signal.h>
#include <setjmp.h>

#ifdef TIME_WITH_SYS_TIME
#  include <sys/time.h>
#  include <time.h>
#else
#  if HAVE_SYS_TIME_H
#    include <sys/time.h>
#  else
#    include <time.h>
#  endif
#endif

#ifdef HAVE_LANGINFO_H
#include <langinfo.h>
#endif

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#ifndef HAVE_DLFCN_H
#error *** We need the dlfcn library
#endif
#include <dlfcn.h>

/* insist multithread */
#include "threads.h"


/** SHORT
	Minimum and maximum value of a I{short} and I{unsigned short}.

	Note that all unsigned MIN values are 0.
*/
#ifndef SHORT_MAX
#  if SIZEOF_SHORT == 2
#     define SHORT_MAX 65535
#  else
#    error "unexpected sizeof short, not 2"
#  endif
#endif
#ifndef SHORT_MIN
#define SHORT_MIN (-SHORT_MAX - 1)
#endif

#ifndef USHORT_MAX
#define USHORT_MAX ((unsigned short) 65535)
#endif
#ifndef USHORT_MIN
#define USHORT_MIN 0
#endif


/** INT
	Minimum and maximum value of a I{int} and I{unsigned int}.

	Note that all unsigned MIN values are 0.
*/
#ifndef INT_MAX
#  if SIZEOF_INT == 4
#    define INT_MAX 2147483647
#  else
#    error "unexpected size of int, not 4"
#  endif
#endif
#ifndef INT_MIN
#define INT_MIN (-INT_MAX - 1)
#endif

#ifndef UINT_MAX
#define UINT_MAX 4294967295U
#endif
#ifndef UINT_MIN
#define UINT_MIN 0U
#endif


/** LONG
	Minimum and maximum value of a I{long} and I{unsigned long}.

	Note that all unsigned MIN values are 0.
*/
#ifndef LONG_MAX
#  if SIZEOF_LONG == 4
#    define LONG_MAX 2147483647L
#  elif SIZEOF_LONG == 8
#    define LONG_MAX 9223372036854775807L
#  else
#    error "unexpected size of long, not 4 nor 8"
#  endif
#endif
#ifndef LONG_MIN
#define LONG_MIN (-LONG_MAX - 1L)
#endif

#ifndef ULONG_MAX
#  if SIZEOF_LONG == 4
#     define ULONG_MAX 4294967295UL
#  elif SIZEOF_LONG == 8
#     define ULONG_MAX 18446744073709551615UL
#  else
#    error "unexpected size of long, not 4 nor 8"
#  endif
#endif
#ifndef ULONG_MIN
#define ULONG_MIN 0UL
#endif


/** LONG_LONG
	Minimum and maximum value of a I{long long} and I{unsigned long long}.

	Note that all unsigned MIN values are 0.
*/
#ifdef HAVE_LONG_LONG

#  ifndef LONG_LONG_MAX
#    if SIZEOF_LONG_LONG == 8
#       define LONG_LONG_MAX 9223372036854775807LL
#    elif SIZEOF_LONG_LONG == 16
#       define LONG_LONG_MAX 170141183460469231731687303715884105727LL
#    else
#       error "unexpected sizeof long long, not 8 nor 16"
#    endif
#  endif
#  ifndef LONG_LONG_MIN
#  define LONG_LONG_MIN (-LONG_LONG_MAX - 1LL)
#  endif

#  ifndef ULONG_LONG_MAX
#    if SIZEOF_LONG_LONG == 8
#       define ULONG_LONG_MAX 18446744073709551615ULL
#    elif SIZEOF_LONG_LONG == 16
#       define LONG_LONG_MAX 340282366920938463463374607431768211455ULL
#    else
#       error "unexpected sizeof long long, not 8 nor 16"
#    endif
#  endif
#  ifndef ULONG_LONG_MIN
#  define ULONG_LONG_MIN 0ULL
#  endif

#endif


/** DBL
	Minimum and maximum value of a I{double} and I{long double}.

	These are suppose to be always defined but this is C ...

	@warn
	Notice that DBL_MIN and LDBL_MIN are positive values.
*/
#ifndef DBL_MIN
#  define DBL_MIN 2.2250738585072013e-308
#endif
#ifndef DBL_MAX
#  define DBL_MAX 1.7976931348623157e+308
#endif

#ifdef HAVE_LONG_DOUBLE
#  ifndef LDBL_MIN
#    define LDBL_MIN 3.362103143112093e-4932L
#  endif
#  ifndef LDBL_MAX
#    define LDBL_MAX 1.189731495357231e+4932L
#  endif
#endif


/** BEGIN END
	Use these to build block macros.

	@xmp
		#define FOOBAR(f, b) \
		BEGIN \
			if ((b) == 0) \
				THROW (EFoo); \
			f = b; \
		END
*/
#define BEGIN do {
#define END   } while (0)


/** Craps
	Crappy C stuffs that need to be fixed.
*/
#ifndef isfinite
#define isfinite  finite
#endif
#ifndef isfinitel
#define isfinitel finitel
#endif


/***/
#undef DEBUG_SEGV
#endif /*_H_base_*/
