/* err.h - Copyright (c) Marc Krisnanto */

#ifndef _H_err_
#define _H_err_ 1

#include "base.h"


/** _err_do
	This is the function called by the macros. You should not call this
	function directly.

	@args
	.file  the file name, i.e. C{__FILE__}
	.func  the function name, i.e. C{__FUNCTION__}
	.kind  C{0}=remark, C{1}=warning, C{2}=experiment warning, C{3}=deprecated warning, C{4}=fatal error
	.fmt   format ala f{printf}
	....   the format arguments
*/
extern void _err_do (const char *file, const char *func, int kind, const char *fmt, ...);


/** FATAL WARN REMARK DEPRECATED EXPERIMENTAL
	Print message to I{stderr}.

	REMARK is enabled if DEBUG is defined. You can disable it by defining
	the macro DISABLE_REMARK.

	WARN is enabled even if DEBUG is not defined. You can disable it by
	defining the macro DISABLE_WARN.

	FATAL is always enabled. It calls C{abort()} so it never return.

	DEPRECATED and EXPERIMENTAL are always enabled.

	@note
		v{errno} is preserved, i.e. calling these macros does not change v{errno}.

	@xmp
		FATAL ("%s is not %s", some_c_string, another_c_string);
*/
#define FATAL(...)        _err_do (__FILE__, __FUNCTION__, 4, __VA_ARGS__)
#define DEPRECATED(...)   _err_do (__FILE__, __FUNCTION__, 3, __VA_ARGS__)
#define EXPERIMENTAL(...) _err_do (__FILE__, __FUNCTION__, 2, __VA_ARGS__)
#define WARN(...)         _err_do (__FILE__, __FUNCTION__, 1, __VA_ARGS__)
#define REMARK(...)       _err_do (__FILE__, __FUNCTION__, 0, __VA_ARGS__)

#if !defined(DEBUG) || defined(DISABLE_REMARK)
#undef REMARK
#define REMARK(...)
#endif

#if defined(DISABLE_WARN)
#undef WARN
#define WARN(...)
#endif

/***/
#endif /*_H_err_*/
