/******************************** -*- C -*- ****************************
 *
 *	lightning main include file
 *
 ***********************************************************************/


/***********************************************************************
 *
 * Copyright 2000 Free Software Foundation, Inc.
 * Written by Paolo Bonzini.
 *
 * This file is part of GNU lightning.
 *
 * GNU lightning is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation; either version 2.1, or (at your option)
 * any later version.
 * 
 * GNU lightning is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with GNU lightning; see the file COPYING.LESSER; if not, write to the
 * Free Software Foundation, 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA.
 *
 ***********************************************************************/



#ifndef __lightning_h
#define __lightning_h

#ifdef __cplusplus
extern "C" {
#endif

#include "base.h"

#ifndef LIGHTNING_CPU_NONE
#  include "lightning/asm-common.h"
#  if defined(LIGHTNING_CPU_I386)
#    include "lightning/i386/asm.h"
#    include "lightning/i386/core.h"
#    include "lightning/core-common.h"
#    include "lightning/i386/funcs.h"
#    include "lightning/funcs-common.h"
#    include "lightning/i386/fp.h"
#    include "lightning/fp-common.h"
#  elif defined(LIGHTNING_CPU_SPARC)
#    include "lightning/sparc/asm.h"
#    include "lightning/sparc/core.h"
#    include "lightning/core-common.h"
#    include "lightning/sparc/funcs.h"
#    include "lightning/funcs-common.h"
#    include "lightning/sparc/fp.h"
#    include "lightning/fp-common.h"
#  elif defined(LIGHTNING_CPU_PPC)
#    include "lightning/ppc/asm.h"
#    include "lightning/ppc/core.h"
#    include "lightning/core-common.h"
#    include "lightning/ppc/funcs.h"
#    include "lightning/funcs-common.h"
#    include "lightning/ppc/fp.h"
#    include "lightning/fp-common.h"
#  endif
#endif

#if 0
#ifndef JIT_R0
#error GNU lightning does not support the current target
#endif
#endif

#ifdef __cplusplus
}
#endif

#endif /* __lightning_h */
