/* qu.h - Copyright (c) Marc Krisnanto */

#ifndef _H_qu_
#define _H_qu_ 1


/** Includes
	Files included by qu.h.
*/
#include "err.h"
#include "ascii.h"

#include "Object.h"
#include "sig.h"
#include "attr.h"
#include "gc.h"
#include "interp.h"
#include "Sys.h"

#include "Tokenizer.h"
#include "Ast.h"
#include "Compile.h"

#include "Array.h"
#include "Big.h"
#include "Boolean.h"
#include "Buffer.h"
#include "Class.h"
#include "Code.h"
#include "Complex.h"
#include "Container.h"
#include "Decimal.h"
#include "Dict.h"
#include "Dlib.h"
#include "Exception.h"
#include "File.h"
#include "Float.h"
#include "Frame.h"
#include "Function.h"
#include "Int.h"
#include "Integer.h"
#include "Inf.h"
#include "Iterator.h"
#include "Long.h"
#include "Method.h"
#include "Module.h"
#include "Null.h"
#include "Number.h"
#include "Opaque.h"
#include "Proc.h"
#include "Pointer.h"
#include "Queue.h"
#include "Range.h"
#include "Rational.h"
#include "Real.h"
#include "Record.h"
#include "Set.h"
#include "Stream.h"
#include "String.h"
#include "Struct.h"
#include "Sub.h"
#include "Thread.h"
#include "Utf8.h"
#include "Var.h"
#include "Weak.h"


/** DEBUG_LOCAL
	Define this before including C{qu.h} to activate f{assert} in your
	C source file.
*/
#ifdef DEBUG_LOCAL
#undef assert
#define assert(expr) \
BEGIN \
	if (!(expr)) \
	{ \
		FATAL ("%s line %d assertion failed: %s", __FUNCTION__, __LINE__, #expr); \
	} \
END
#endif


/** APP_DEBUG
	Set __debug__ value.

	This is set with the C{-d} option.

	The default value is 0 which means __debug__ = false.

	Note that the __debug__ value can not be modified programmatically.
*/
extern int APP_DEBUG;


/** APP_VERBOSE
	Set by the C{-o} option.

	The default value is 0 (false) which means silent.
*/
extern int APP_VERBOSE;


/** APP_NO_WARNING
	Whether or not warning messages should be generated.

	Warnings are disabled with the C{-w} option.

	The default value is 1 (true).
*/
extern int APP_NO_WARNING;


/** APP_LINE_NUMBER
	Whether or not line number should be generated.

	Line numbers are not generated by specifying the C{-l} option.

	The default value is 0 (false).
*/
extern int APP_LINE_NUMBER;


/** APP_INCLUDE_TEST
	Whether or not the code below the k{__test__} line should be included.

	They are enabled by specifying the C{-t} option.

	The default value is 0 (false).
*/
extern int APP_INCLUDE_TEST;


/** APP_KEEP_TREE
	Whether or not to keep the parsed trees.

	This is enabled with the C{-p} option.

	The default value is 0, i.e. free the parsed trees after compilation.

	The only reason you want to keep the tree is to print it because the compiler
	does not provide any means to modify it.
*/
extern int APP_KEEP_TREE;


/** APP_WITH_DOC
	Include documentation strings.

	This is enabled with the C{-D} option.

	The default value is 0 (false).
*/
extern int APP_WITH_DOC;


/** APP_HOME_DIR
	Where Qu is installed.

	This is where Qu should think where it is installed.
	It is set with the C{-M} option.

	The default value is APP_DESTDIR as set in config.h.
*/
extern const char *APP_HOMEDIR;


/** APP_OPTIMIZE_CODE
	Optimize code.

	Currently this implies that the code should be JIT-ed, if possible.
	It is set with the C{-O} option.

	The default value is 0 (false).
*/
extern int APP_OPTIMIZE_CODE;


/** APP_MORE_COMPILE_CHECK
	Perform more compile-time checkings.

	If true then Qu must do more compile-time checking, e.g. check typed
	variables against constant properties, etc.

	The default value is 0 (false).
*/
extern int APP_MORE_COMPILE_CHECK;


/** APP_FREE_LEXICAL
	Free all lexical Var objects after compiling.

	This is set with the C{-x} option.

	The default value is 1 (true).
*/
extern int APP_FREE_LEXICAL;


/** APP_NOVALIDATION
	Deactivate all validators.

	The default value is 0 (false).
*/
extern int APP_NOVALIDATION;


/** APP_USEPACKAGE
	Set __package__ to this directory instead.

	This is set with the C{-K} option. Default is NULL.
*/
extern char *APP_USEPACKAGE;


#endif /*_H_qu_*/
