/* sig.h - Copyright (c) Marc Krisnanto */

#ifndef _H_sig_
#define _H_sig_ 1

#include "base.h"
#include "threads.h"


/** SigTerminated
	Is a termination signal caught?

	This is for the interpreter to save a function call to #{SigGotTERM}.
*/
extern int volatile SigTerminated;


/** SigInterrupt
	Is a keyboard interrupt caught?

	This is for the interpreter to save a function call to #{SigGotINT}.
*/
extern int volatile SigInterrupt;


/** SigInit
	Initialize signals.

	If v{blocksig} is non-zero then signals are blocked.
*/
extern void SigInit (int blocksig);


/** SigInitWorker
	All worker threads must call this function just after they have been
	born into existance.

	If SigInit was called with blocksig = 0 then this function does nothing,
	otherwise signals are blocked from the thread.
*/
extern void SigInitWorker ();


/** SigGot SigAck
	SigGot functions check whether or not a signal has been delivered.

	Each signal has a counter. When a signal is delivered, the count is
	incremented.

	SigAck functions decrement the signal counter.
*/
extern int  SigGotTERM ();
extern int  SigGotINT  ();
extern int  SigGotALRM ();
extern int  SigGotHUP  ();
extern int  SigGotPIPE ();
extern int  SigGotUSR1 ();
extern int  SigGotUSR2 ();

extern void SigAckTERM ();
extern void SigAckINT  ();
extern void SigAckALRM ();
extern void SigAckHUP  ();
extern void SigAckPIPE ();
extern void SigAckUSR1 ();
extern void SigAckUSR2 ();


/** SigIntHook
	Set this variable to a hook function to call whenever SIGINT is caught.
	Set it to NULL to disable it.

	@warn
	Do not set if you are going to block (i.e. ={__Blocking}Begin/End).
	Do not forget to set it to NULL after you are done.
*/
typedef void (*sigint_f) ();
extern volatile sigint_f SigIntHook;


/** SigHook
	Set these variables to a hook function to call whenever SIGALRM, SIGHUP,
	SIGPIPE, SIGUSR1, or SIGUSR2 is caught. Set to NULL to disable.

	@warn
	Do not set if you are going to block (i.e. ={__Blocking}Begin/End).
	Do not forget to set it to NULL after you are done.
*/
typedef void (*sighook_f) ();
extern volatile sighook_f SigHookCHLD;
extern volatile sighook_f SigHookALRM;
extern volatile sighook_f SigHookHUP;
extern volatile sighook_f SigHookPIPE;
extern volatile sighook_f SigHookUSR1;
extern volatile sighook_f SigHookUSR2;

/***/


#endif /*_H_sig_*/
