/* Db.h - Copyright (c) Marc Krisnanto */

#ifndef _H__Db_
#define _H__Db_ 1

#include "qu.h"

/*
	This module provides standard interface to relational databases.

	See the dbd/Generic.c and dbd/MySQL.c source files for examples on how
	to write drivers.. They are simple and straightforward, no explanation
	required.
*/

/*
	These are the database function prototypes.
	See dbd_s for what they mean.
*/
typedef int         (*dbdcapability_f) (int what);
typedef void       *(*dbdconnect_f   ) (Dict data);
typedef void        (*dbddisconnect_f) (void *h);
typedef void        (*dbdfree_f      ) (void *h);
typedef int         (*dbderrnum_f    ) (void *h);
typedef const char *(*dbderrstr_f    ) (void *h);
typedef void        (*dbdfinish_f    ) (void *h);
typedef int         (*dbdbegin_f     ) (void *h);
typedef int         (*dbdrollback_f  ) (void *h);
typedef int         (*dbdcommit_f    ) (void *h);
typedef long        (*dbdaction_f    ) (void *h, const char *sql);
typedef long        (*dbdlastid_f    ) (void *h);
typedef int         (*dbdselect_f    ) (void *h, const char *sql);
typedef int         (*dbdfetchrow_f  ) (void *h, const char ***row);
typedef int         (*dbdnumfields_f ) (void *h);
typedef int         (*dbdfieldtype_f ) (void *h, int index);
typedef const char *(*dbdfieldname_f ) (void *h, int index);
typedef int         (*dbdescape_f    ) (void *h, char *buf, const char *s, int len);

/*
	This struct represents a database driver.
*/
typedef struct dbd_s dbd_s;
struct dbd_s
{
	dbdcapability_f  cap;        /* Get driver capability */
	dbdconnect_f     connect;    /* Make a new connection */
	dbddisconnect_f  disconnect; /* Close an existing connection */
	dbdfree_f        free;       /* Free an existing connection */
	dbderrnum_f      errnum;     /* Get current error code */
	dbderrstr_f      errstr;     /* Get current error message */
	dbdfinish_f      finish;     /* Finish using query result */
	dbdbegin_f       begin;      /* Begin transaction */
	dbdrollback_f    rollback;   /* Abort transaction */
	dbdcommit_f      commit;     /* Commit transaction */
	dbdaction_f      action;     /* Perform an action query */
	dbdlastid_f      lastid;     /* Get last record ID number */
	dbdselect_f      select;     /* Perform a select query */
	dbdfetchrow_f    fetchrow;   /* Fetch one row of a query result */
	dbdnumfields_f   numfields;  /* Get number of fields of a select query result */
	dbdfieldtype_f   fieldtype;  /* Get field type of a select query result */
	dbdfieldname_f   fieldname;  /* Get field name of a select query result */
	dbdescape_f      escape;     /* SQL escape a string */
};

/*
	For the field 'what' of dbdcapability_f.
*/
#define Db_CAPABILITY_THREADSAFE    0x000000
#define Db_CAPABILITY_TRANSACTION   0x000001
#define Db_CAPABILITY_AUTORECONNECT 0x000002


/*
	For dbdfieldtype_f, the supported value types.

	Note that in script level Db_TYPE_INT is named Db_TYPE_INTEGER and covers
	all Integer types (Db_TYPE_LONG and Db_TYPE_LONGLONG).
*/
#define Db_TYPE_UNKNOWN   0   /* converted to Str */
#define Db_TYPE_NULL      1   /* converted to nil */
#define Db_TYPE_INT       2   /* converted to Integer */
#define Db_TYPE_LONG      3   /* converted to Integer */
#define Db_TYPE_LONGLONG  4   /* converted to Integer */
#define Db_TYPE_FLOAT     8   /* converted to Float */
#define Db_TYPE_STR       9   /* converted to Str */
#define Db_TYPE_TEXT      10  /* converted to Str */
#define Db_TYPE_BLOB      11  /* converted to Str */

/***/
#endif /*_H__Db_*/
