/* Foo.c - Copyright (c) Fooey */

#include "qu.h"


/*) module Foo
	...
*/


/*============================================================================

	module functions

============================================================================*/

/*) sub boo (x: Integer) -> Integer
	...
*/
static Integer Foo_boo (Integer xx)
{
	long x;

	ArgTOLI (xx, x);  /* see Sub.h */
	...

	return (Integer) Int1;
}



/*============================================================================

	class Foo

============================================================================*/

/*) class Foo
	The non-final Foo class.

	...
	...
*/
static Class FooClass;



/*
	The Foo instance struct.
*/
typedef struct TFoo TFoo;
struct TFoo
{
	OBJ_HEAD;
	String  name;    /* my name */
	char   *buffer;  /* buffer is GcMemMalloc-ed */
	...
};
typedef TFoo *Foo;



/*
	Whether or not x is a Foo
*/
#define FooIs(x) ObjectInstOf ((x), FooClass)



/*----------------------------------------------------------------------------
	allocation

	Remember to keep the allocation stuffs in one place.
	If you keep GcNew-ing all over the place then you are asking for trouble.

----------------------------------------------------------------------------*/

static Foo _Foo_alocate (Class self, String name, long bufsiz)
{
	Foo o;

	assert (self->size <= FooClass->size);
	assert (n > 0);

	REQUIRE (EMemory, n < GC_MEM_MAXSIZE);  /* see Exception.h and Gc.h */

	o = GcNew (Foo);
	o->name = name;
	o->bufffer = GcMemMalloc (bufsiz);
	...
	return o;
}



/*----------------------------------------------------------------------------
	standard class methods
----------------------------------------------------------------------------*/

/*) sub class __inst (x: String) -> Foo
	...
*/
static Foo Foo__inst (Class self, String x)
{
	...
}



/*) sub class new (x: String) -> Foo
	...
*/
static Foo Foo_new (Class self, String x)
{
	...
}



/*----------------------------------------------------------------------------
	specific class methods
----------------------------------------------------------------------------*/

/*) sub class dang (a: String, b: Integer = 100) -> Boolean
	...
*/
static Boolean Foo_dang (Class self, String a, Integer bb)
{
	long b;

	REQUIRE (EValue, StringIs (a));
	ArgTOLI (bb, b);

	...
}



/*----------------------------------------------------------------------------
	low-level instance methods
----------------------------------------------------------------------------*/

static void Foo__free (Foo self)
{
	GcMemFree (self->mem);
	...
}



static void Foo__mark (Foo self)
{
	GcMark (self->bar);
	...
}



/*----------------------------------------------------------------------------
	standard instance methods
----------------------------------------------------------------------------*/

/*) sub __print -> Null */
static Null Foo__print (Foo self)
{
	...

	return Nil;
}



/*) sub __string -> String */
static String Foo__string (Foo self)
{
	...

	return StringEMPTY;
}



/*----------------------------------------------------------------------------
	specific instance methods
----------------------------------------------------------------------------*/

/*) sub bar (*arg) -> Boolean
	@code
	sub bar (a: Int) -> Boolean
	sub bar -> Boolean
	...
*/
static Boolean Foo_bar (Foo self, int argc, Any *argv)
{
	int v = 0;

	ArgVCOUNT (0, 1);
	if (argc > 0)
		ArgVTOUI (1, v);

	...

	return True;
}



/*) sub baz (s:String, i:Int) -> self
	...
*/
static Foo Foo_baz (Foo self, String s, Int ii)
{
	long i;

	REQUIRE (EValue, StringIs (s));
	ArgTOI (ii, i);
	...
	return self;
}



/*============================================================================

	init

============================================================================*/

int Foo_init (Module m)
{
	/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
		module functions
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

	ModuleAddFunction (m, "boo", Foo_boo, 1);


	/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
		class Foo
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

	FooClass = ClassNewz (m, "Foo", TFoo, Foo__free, Foo__mark);

	/* standard class methods */
	ClassMethodClass  (FooClass, A__inst  , Foo__inst  ,  1);
	ClassMethodClass  (FooClass, A_new    , Foo_new    ,  1);

	/* specific class methods */
	ClassMethodClassz (FooClass, "dang"   , Foo_dang   ,  2);

	/* standard isntance methods */
	ClassMethodInst   (FooClass, A__print , Foo__print ,  0);
	ClassMethodInst   (FooClass, A__string, Foo__string,  0);

	/* specific instance methods */
	ClassMethodInstz  (FooClass, "bar"    , Foo_bar    , -1);
	ClassMethodInstz  (FooClass, "baz"    , Foo_baz    ,  2);

	return 1;
}
