#!/bin/bash
if [ -d /usr/share/mkpkg ] ; then
	echo -n ""
else
	mkdir /usr/share/mkpkg
fi
echo "MKPKG - A tool to automate package building"
echo "(C)2005 A.J. Venter"
echo "This tool is not perfect - TEST the packages"
echo "Critical usage information is located in /usr/share/mkpkg/README"
echo "If you haven't read it yet, hit CTRL-C now and read it first."

PACKAGE_NUMBER="1"
echo -n "Enter package name:" 
read PACKAGE_NAME
echo -n "Enter package version:"
read PACKAGE_VERSION
echo -n "Enter target platform:"
read PACKAGE_TARGET
echo -n "Would you like me to try and autogenerate a dependancies list[y/n] ?"
read AUTODEP
	if echo $AUTODEP | grep "[yY]" > /dev/null ; then
		rm -f /tmp/slack-required
	fi

if [ -r /usr/share/mkpkg/builder.profile ] ; then
	source /usr/share/mkpkg/builder.profile
else
	echo -n "Enter your name:"
	read BUILDER_NAME
	echo -n "Enter your e-mail address:"
	read BUILDER_EMAIL
	echo  -n "Enter your initials:"
	read PACKAGE_INITIALS
fi

if [ $EDITOR.x==".x" ] ; then
	EDITOR="vim"
fi

if ./configure --help 2> /dev/null; then
	echo
	echo  "Previous configure options (if any):"
	grep "$PACKAGE_NAME" < /var/log/mkpkg 

	echo -n "Enter configure options:"
	read CONFIG_OPTIONS
#Save these
	echo "$PACKAGE_NAME $CONFIG_OPTIONS" >> /var/log/mkpkg

	echo "Configuring"
	./configure $CONFIG_OPTIONS
fi

if [ -d /usr/share/mkpkg/$PACKAGE_NAME ] ; then
	echo "Emptying build tree"
	rm -fr /usr/share/mkpkg/$PACKAGE_NAME
fi
echo "Creating build tree"
mkdir -p /usr/share/mkpkg/$PACKAGE_NAME

if grep "DESTDIR" < Makefile ; then
echo "The makefile supports the DESTDIR construct. I reccomend this if it works"
echo "but check the result - it doesn't always."
echo -n "Uses DESTDIR [y/n] ?"
read USE_DESTDIR
else
     USE_DESTDIR="no"
fi

echo "Compiling"
if make ; then
	echo "Compile succeeded"
else
	echo "Compilation failed -check your settings"
	exit 1
fi

if echo $USE_DESTDIR | grep [yY] ; then
	make install DESTDIR=/usr/share/mkpkg/$PACKAGE_NAME
else
	echo "Right, I'll use installwatch instead"
	rm /tmp/mkpkg-files
	installwatch -o /tmp/mkpkg-files make install
	for I in `cat /tmp/mkpkg-files |grep -v "/dev" | grep "open" | grep -v "fopen" | awk '{print $3'} | uniq` ; do
		echo $I
		if [ -d $I ] ; then 
			mkdir -p /usr/share/mkpkg/$PACKAGE_NAME/$I;
		else
			#creating the directories never hurt
			mkdir -p /usr/share/mkpkg/$PACKAGE_NAME/`slackdir $I`
			cp -pv $I /usr/share/mkpkg/$PACKAGE_NAME/.$I
		fi
	done
fi
mkdir /usr/share/mkpkg/$PACKAGE_NAME/install



cd /usr/share/mkpkg/$PACKAGE_NAME
for I in `find` ; do
	if file $I | grep "ELF" >/dev/null ; then
	strip --strip-all $I
	if echo $AUTODEP | grep "[yY]" > /dev/null ; then
		echo "Searching dependancies for $I"
		slackdeps $I >> install/slack-required
	fi
	fi
done

cd /usr/share/mkpkg

echo "Creating slack-desc file"
#links http://www.linuxpackages.net/slackcreator.php

cp /usr/share/mkpkg/install/slack-desc /usr/share/mkpkg/$PACKAGE_NAME/install

echo "I will now start an editor, enter the package description inside it"
echo -n "Press enter when ready"
read
$EDITOR /tmp/slack-desc
	
if echo $AUTODEP | grep "[yY]" > /dev/null ; then
#Next remove any double entries from the slackrequired file
cp /usr/share/mkpkg/$PACKAGE_NAME/install/slack-required /tmp/slack-required
sort  /tmp/slack-required | uniq | grep -v "$PACKAGE_NAME" > /usr/share/mkpkg/$PACKAGE_NAME/install/slack-required
echo "You have chosen to autogenerate a dependancies list"
echo "since this is not a 100% acurate procedure"
echo "I will now start an editor for you to double check it"
$EDITOR /usr/share/mkpkg/$PACKAGE_NAME/install/slack-required
fi
if [ -r /usr/share/mkpkg/$PACKAGE_NAME/install/slack-required~ ] ; then
	rm -f  /usr/share/mkpkg/$PACKAGE_NAME/install/slack-required~ 
fi
	

slackheader $PACKAGE_NAME >> /usr/share/mkpkg/$PACKAGE_NAME/install/slack-desc
slackbody $PACKAGE_NAME >> /usr/share/mkpkg/$PACKAGE_NAME/install/slack-desc "$BUILDER_NAME" "$BUILDER_EMAIL"

cd /usr/share/mkpkg/$PACKAGE_NAME

while [ -r /usr/share/mkpkg/$PACKAGE_NAME-$PACKAGE_VERSION-$PACKAGE_TARGET-$PACKAGE_NUMBER$PACKAGE_INITIALS.tgz ] ; do
	PACKAGE_NUMBER=`expr $PACKAGE_NUMBER + 1`
done

makepkg /usr/share/mkpkg/$PACKAGE_NAME-$PACKAGE_VERSION-$PACKAGE_TARGET-$PACKAGE_NUMBER$PACKAGE_INITIALS.tgz

