#!/bin/sh
#################################################################################################
# Slackware update script									#
#												#
# Description:  This script was written to keep a slackware system up to date with the patches	#
#		directory of a given release.  This script should probably not be used on a	#
#		slackware-current system unless you really know what you are doing.  There are 	#
#		3 runlevels available. 0 and 1 are both safe and will not do anything to your	#
#		system.  2 can be dangerous depending on what you are updating.  		#
#												#
# Supports:	Slackware 8.1 - slackware-current					#
#												#
# Requirements: cat cp cut echo -e grep ls md5sum mkdir pwd rm rmdir sed tr wc wget which	#
#		upradepkg									#
#		(all of these should be on a slackware system by default)			#
#												#
# Contact Info:	Rob Hunter <rhunter[AT]vt[D0T]edu>						#
#################################################################################################

#################
# Configuration #
#################
#Server1="http://slackware-gus.osuosl.org"
Server1="ftp://carroll.cac.psu.edu/pub/linux/distributions/slackware"
Server2="ftp://distro.ibiblio.org/pub/Linux/distributions/slackware"
Server3="ftp://ftp.slackware.com/pub/slackware"
Server4="ftp://mirror.switch.ch/mirror/slackware"
Server5="ftp://ftp.slackware.no/pub/linux/slackware"

Color=1		# Color Output: 0 - Disable Color output
		#		1 - Enable Color output

 		# FireWall / Proxy Configuration (Not Enabled by Default)
#http_proxy=""	# e.g. http_proxy="http://proxy:3128/"
#ftp_proxy=""	# e.g. ftp_proxy="http://proxy/proxy.pac"

Passiv=1	# Passive:	0 - Disable Passive transfers
		#		1 - Enable Passive transfers

Proz=0		# Prozilla:	0 - Disable use of prozilla
		#		1 - Enable use of prozilla

RunLevel=1	# RunLevels:	0 - Only Check for Updates
		# 		1 - Check for and Download Updates [Recomended]
		#		2 - Automaticly Install Updates (Be carefull with this one)
		
Verbose=0	# verbosity:	0 - Only show updated packages
		#		1 - Show status of all patches found on server

VersionCheck=1	# VersionCheck: 0 - Do not check for a newer version of slackupdate
		#		1 - Check for a new slackupdate [Default]

TEMPDIR="/tmp/slackupdate"	# Temporary Directory
				# (WARNING ALL CONTENT IS ERASED!)

BlackList="/etc/slackupdate_blacklist"	#Package names that should not be updated

##################-[You do not need to configure anything below this line]-##################

###########
# Globals #
###########
VERSION="Slackware Update Version [0.7.1]"
HELP="
Usage: slackupdate.sh [-l (0|1|2)] [-nc] [-np] [-o /directory] [-pr] [-r]
 [-s server] [-t /directory] [-u version] [-h] [-v]

  -l (0|1|2)	Runlevel, (0 - check | 1 - Download | 2 - Automatic)
  -nc		Disables Color
  -np		Disables Passiv transfers
  -o (/dir)	Output Directory, Place to put downloaded packages
  		e.g. [-o ~/slackupdate]
  -pr		Enable prozilla downloader instead of wget
  -r		Retry, Will not re-downloading updates you already have.
  -t (/dir)	Temporary Directory [-t /tmp/slackupdate]
  -s (server)	Preferred server e.g. [-s ftp://ftp.slackware.com/pub/slackware]
  -u (version)	Upgrade to the specified version of slackware !!!EXPERIMENTAL!!!
  -v		More verbosity
  -h		This help dialog.  May also use (-help|--help|-?)
  
[Runtime examples]
slackupdate.sh				# Download updates for your system
slackupdate.sh -r -u slackware-10.1	# Download upgrade to slackware-10.1
slackupdate.sh -r -l 2 -u slackware-10.1	# Upgrade to slackware-10.1
"
COMMANDS="cat cp cut echo grep ls md5sum mkdir pwd rm rmdir sed sort tr wc which /sbin/upgradepkg"
NoUpdates=1
Patches="patches"
Retry=0

#############
# Functions #
#############

# Define exit/failure function.
exit_failure() {
  if [ ! -z "$FAILURE" ]; then
    echo -e "${C_Error} [ FAILED ]"
    echo -e "-> FATAL: $FAILURE"
    echo -e "-> ** ABORTED **.${C_End}"
    exit 1
  else
    exit 0
  fi
}

# Checks for a newer version of this script
check_for_new_version() {
  if [ "$VersionCheck" == 1 ]; then
    current=`echo -e $VERSION | grep -i Pre`
    if [ -z "$current" ]; then
      current="version"
    else
      current="version-current"
    fi
    slackupdateserver="http://www.darklinux.net/slackupdate/files"
    echo -e -n "Checking for a newer version of slackupdate.sh "
    Target="$slackupdateserver/$current"
    download
    if [ -r $current ]; then
      NVERSION=`cat $current`
      if [ "$NVERSION" == "$VERSION" ]; then
        echo -e "[${C_Info}Up2Date${C_End}]"
      else
        echo -e
        echo -e "${C_Info}$NVERSION${C_End} is available"
	if [ "$current" == "version" ]; then
          echo -e "Download from $slackupdateserver/slackupdate.sh"
	else
	  echo -e "Download from $slackupdateserver/slackupdate-current.sh"
	fi
      fi
    else
      echo -e "[${C_Error}server down${C_End}]"
    fi
  fi
}

# check to see if we should use color or not
check_for_color() {
  if [ "$Color" == "1" ]; then
    C_Warning="\\033[1;33m"
    C_Error="\\033[1;31m"
    C_Ok="\\033[1;32m"
    C_End="\\033[0;00m"
    C_Info="\\033[36;40m"
  fi
}

# check to make sure all the commands are there
check_for_commands() {
  for COMMAND in $COMMANDS; do
    which $COMMAND 1> /dev/null 2> /dev/null
    if [ $? != 0 ]; then
      FAILURE="$COMMAND not found.  please install $COMMAND first"
      exit_failure
    fi
  done
}

check_for_gpg() {
  Use_GPG=1
  for COMMAND in "gpg gpgv"; do
    which $COMMAND 1> /dev/null 2> /dev/null
    if [ $? != 0 ]; then
      Use_GPG=0
    fi
  done
  if [ "$Use_GPG" == 1 ]; then
    gpg --keyring ~/.gnupg/trustedkeys.gpg --list-public-keys 40102233 1> /dev/null 2> /dev/null
    if [ $? != 0 ]; then
      gpg --keyserver hkp://subkeys.pgp.net --no-default-keyring --keyring ~/.gnupg/trustedkeys.gpg --recv-keys 40102233 1> /dev/null 2> /dev/null
      gpg --keyring ~/.gnupg/trustedkeys.gpg --list-public-keys 40102233 1> /dev/null 2> /dev/null
      if [ $? != 0 ]; then
        Use_GPG=0
      fi
    fi
    gpg --keyring ~/.gnupg/trustedkeys.gpg --list-public-keys B181EC7C 1> /dev/null 2> /dev/null
    if [ $? != 0 ]; then
      gpg --keyserver hkp://subkeys.pgp.net --no-default-keyring --keyring ~/.gnupg/trustedkeys.gpg --recv-keys B181EC7C 1> /dev/null 2> /dev/null
      gpg --keyring ~/.gnupg/trustedkeys.gpg --list-public-keys B181EC7C 1> /dev/null 2> /dev/null
      if [ $? != 0 ]; then
        Use_GPG=0
      fi
    fi
  fi
}

# Remove the temp directory
clean_tempdir() {
  if [ -d $TEMPDIR ]; then
    cd "$TEMPDIR"
    TEMPDIR=`pwd`
    if [ -w $TEMPDIR ]; then
      rm -f *.md5 *.asc version* CHECKSUMS* 1> /dev/null 2> /dev/null
      if [ $Retry == 0 ]; then
        rm -f *.tgz 1> /dev/null 2> /dev/null
      fi
      rmdir $TEMPDIR 1> /dev/null 2> /dev/null      
    else
      FAILURE="You do not have write permissions for $TEMPDIR"
      exit_failure
    fi
  elif [ -r "$TEMPDIR" ];then
    FAILURE="Invalid Temp Directory: $TEMPDIR "
    exit_failure
  fi
}

# Copy packages to output directory
copy_output() {
  if [ ! -z "$OUTPUTDIR" ]; then
    cd "$ORGDIR"
    if [ ! -d "$OUTPUTDIR" ]; then
      mkdir "$OUTPUTDIR" 1> /dev/null 2> /dev/null
      if [ $? != 0 ]; then
        FAILURE="Could not create directory $OUTPUTDIR"
        exit_failure
      fi  
    fi
    cd "$OUTPUTDIR"
    OUTPUTDIR=`pwd`
    cp $TEMPDIR/*.tgz $OUTPUTDIR
  fi
  clean_tempdir
}

# Download function
download() {
  if [ $Verbose == "1" ]; then
    $downloader $downloadOptions $Target
  else
    $downloader $downloadOptions $Target 1> /dev/null
  fi
}

# Download new package
download_package() {
  echo -e -n "$PackageName => $TrueUpdateName"
  if [ "$RunLevel" -ge  1 ]; then
    if [ ! -r $TEMPDIR/$TrueUpdateName.tgz ]; then
      echo -e -n " [${C_Ok}Downloading${C_End}]"
      Target="$Server/$Patches/$UpdateName.tgz"
      download
    else
      echo -e -n " [${C_Warning}Already Downloaded${C_End}]"
    fi
    
    if [ "$Use_GPG" == 1 ]; then
      echo -e -n " [${C_Ok}GPG${C_End}]"
      Target="$Server/$Patches/$UpdateName.tgz.asc"
      download
      gpgv "$TrueUpdateName.tgz.asc" "$TrueUpdateName.tgz" 1> /dev/null 2> /dev/null
      if [ $? != 0 ]; then
        echo -e -n " [${C_Error}GPG Mismatch${C_End}] [${C_Error}Deleting${C_End}]"
        rm -f $TEMPDIR/$TrueUpdateName.tgz 1> /dev/null 2> /dev/null
      else
        echo -e -n " [${C_Ok}Done${C_End}]"
      fi
    else
      echo -e -n " [${C_Ok}MD5${C_End}]"
      MD5SUM=`cat $TEMPDIR/CHECKSUMS.md5 | grep "$UpdateName.tgz$" | cut -d" " -f1`
      TRUEMD5SUM=`md5sum $TEMPDIR/$TrueUpdateName.tgz 2> /dev/null | cut -d" " -f1`
      if [ "$MD5SUM" != "$TRUEMD5SUM" ]; then
        echo -e -n " [${C_Error}MD5 Mismatch${C_End}] [${C_Error}Deleting${C_End}]"
        rm -f $TEMPDIR/$TrueUpdateName.tgz 1> /dev/null 2> /dev/null
      else
        echo -e -n " [${C_Ok}Done${C_End}]"
      fi
    fi
  fi
}

# Check for proper downloader program
downloader_check() {
  if [ $Proz == 1 ]; then
    which proz 1> /dev/null 2> /dev/null
    if [ $? == 0 ]; then
      downloader="proz"
      if [ $Passiv == 1 ]; then
        downloadOptions="-f -t 5"
      else
        downloadOptions="-f -t 5 --use-port"
      fi
    fi
  else
    which wget 1> /dev/null 2> /dev/null
    if [ $? == 0 ]; then
      downloader="wget"
      if [ $Passiv == 1 ]; then
        downloadOptions="-t 5 --passive-ftp"
      else
        downloadOptions="-t 5"
      fi
      if [ $Verbose == "0" ]; then
        downloadOptions="$downloadOptions -q"
      fi
    else
      FAILURE="wget not found on your system."
      exit_failure 
    fi  
  fi   
}

# Installs updates for level 1 (Download Only)
install_level_1() {    
  if [ ! -z "$OUTPUTDIR" ]; then
    copy_output
    INSTDIR=$OUTPUTDIR
  else
    INSTDIR=$TEMPDIR
  fi
  echo -e "Updates are located in $INSTDIR"
  echo -e "Install them by using the following command as root:"
  if [ "$Patches" == "slackware" ]; then
    echo -e "  ${C_Info}upgradepkg $INSTDIR/glibc*.tgz${C_End}"
    echo -e "  ${C_Info}upgradepkg $INSTDIR/cxx*.tgz${C_End}"
    echo -e "  ${C_Info}upgradepkg $INSTDIR/pkgtools*.tgz${C_End}"    
    echo -e "  ${C_Info}upgradepkg $INSTDIR/sed*.tgz${C_End}"
    echo -e "  ${C_Info}upgradepkg $INSTDIR/bash*.tgz${C_End}"    
  fi
  echo -e "  ${C_Info}upgradepkg $INSTDIR/*.tgz${C_End}"
  echo -e
  echo -e "${C_Info}If you upgraded a kernel make sure you run lilo.${C_End}"
}

# Installs updates for level 2 (Auto Install)
install_level_2() {
  /sbin/upgradepkg *.tgz
  copy_output
  if [ -r /etc/lilo.conf ]; then
    if [ -x /sbin/lilo ]; then
      /sbin/lilo
    fi
  fi
}

# Installs the upgrade for level2
install_level_2_upgrade() {
  /sbin/upgradepkg glibc*.tgz 2> /dev/null
  /sbin/upgradepkg cxx*.tgz 2> /dev/null
  /sbin/upgradepkg pkgtools*.tgz 2> /dev/null
  /sbin/upgradepkg sed*.tgz 2> /dev/null
  /sbin/upgradepkg bash*.tgz 2> /dev/null
  install_level_2
  RCD_List=`ls /etc/rc.d/*\.new 2> /dev/null`
  if [ ! -z "$RCD_List" ]; then
    for RCD_New in $RCD_List; do
      RCD_Org=`echo -e $RCD_New | sed -e "s/\.new//g"`
      mv $RCD_Org $RCD_Org.old
      mv $RCD_New $RCD_Org
    done
  fi
  if [ "$SVersion" == "slackware-current" ]; then
    echo -e "If this is the first time you are upgrading to slackware-current you may need to run netconfig."
  else
    if [ -x /sbin/netconfig ]; then
      /sbin/netconfig
    fi
  fi
}

# Installs new updates
install_updates() {
  if [ ! -z "`ls $TEMPDIR/*.tgz 2> /dev/null`" ]; then
    NoUpdates=0
  fi
  if [ "$NoUpdates" == "1" ]; then
    echo -e "No new updates found"
    clean_tempdir
  else
    case $RunLevel in
      0)	clean_tempdir
		;;
      1)	install_level_1
		;;		
      2)	echo -e "Installing Updates..."
		if [ "$Patches" == "slackware" ]; then
		  install_level_2_upgrade
		else
		  install_level_2
		fi
		;;
      *)	;;
    esac
  fi
}

# Initalize the temp directory
init_dirs() {
  ORGDIR=`pwd`
  clean_tempdir
  if [ ! -d $TEMPDIR ]; then
    mkdir $TEMPDIR
    if [ $? != 0 ]; then
      FAILURE="Could not create directory $TEMPDIR"
      exit_failure
    fi
    cd "$TEMPDIR"
    TEMPDIR=`pwd` 
  fi
  if [ ! -r $BlackList ]; then
    touch $TEMPDIR/slackupdate_blacklist
    BlackList="$TEMPDIR/slackupdate_blacklist"
  fi
}

# Find and report any .new files that are in /etc
look_for_new_files() {
  if [ "$EUID" == "0" ]; then
    if [ ! -z "`find /etc | grep "\.new$" 2> /dev/null`" ]; then
      echo -e
      echo -e "The following config files have changed:${C_Warning}"
      find /etc | grep "\.new$" 2> /dev/null
      echo -e "${C_End}You may need to manually update them."
    fi
  fi
}

# Check to see if there is a package on the server that is newer than one on this machine
match_packages() {
  UpdateNames=`cat $TEMPDIR/CHECKSUMS.md5 | grep ".tgz$" | grep -v "\.\." | sed -e "s/.*\.\///" | sed -e "s/.tgz//"`
  TestUpdateNames=`cat $TEMPDIR/CHECKSUMS.md5 | grep ".tgz$" | grep -v "\.\." | sed -e "s/.*\///g" | sed -e "s/-[^\-]*$//" | sed -e "s/-[^\-]*$//" | sed -e "s/-[^\-]*$//"`

  if [ "$Patches" == "slackware" ]; then
    PackageNames=`ls /var/log/packages`
    TestPackageNames=`ls /var/log/packages | sed -e "s/-[^\-]*$//" | sed -e "s/-[^\-]*$//" | sed -e "s/-[^\-]*$//"`
    upgrade_changes
  fi
  
  PackageNames=`ls /var/log/packages`
  TestPackageNames=`ls /var/log/packages | sed -e "s/-[0-9A-Z].*//g"`
  PNamesCount=`echo -e $PackageNames | wc -w | sed -e "s/\ //g"`
  
  echo -e "Checking for Updates..."
  pnum=0
  for TestPackageName in $TestPackageNames; do
    if [ "$Verbose" == 1 ]; then
      echo -e -n "Processing package [$((pnum+1)) of $PNamesCount]"
      if [ "$Color" == 1 ]; then
        echo -e -n "\\033[99D"
      else
        echo -e
      fi
    fi
    unum=0
    foundmatch=0
    for TestUpdateName in $TestUpdateNames; do
    
      if [ "$TestUpdateName" == "$TestPackageName" ]; then

 	if [ $foundmatch == 1 ]; then
	  echo -e "${C_Error}WARNING!!! UPDATE FOR THIS PACKAGE ALREADY DOWNLOADED!"
	  echo -e "Please Delete the un-necessary package before installing.${C_End}"
	fi

	PackageName=`echo -e $PackageNames | cut -d \  -f $(($pnum+1))`
	UpdateName=`echo -e $UpdateNames | cut -d \  -f $(($unum+1))`
        TrueUpdateName=`echo -e $UpdateName | sed -e "s/.*\///g"`

	if [ "$TestPackageName" == "kernel-modules" ]; then
	  Modules_PackageName=`echo -e $PackageName | sed -e "s/_.*//g" | sed -e "s/-i[34]86.*//g"`
	  Modules_TrueUpdateName=`echo -e $TrueUpdateName | sed -e "s/_.*//g" | sed -e "s/-i[34]86.*//g"`
	  if [ "$Modules_PackageName" == "$Modules_TrueUpdateName" ]; then
	    TrueUpdateName=$PackageName
	  fi
	fi

        if [ "$PackageName" != "$TrueUpdateName" ]; then
	  blcheck=$(cat $BlackList 2> /dev/null | grep $TestPackageName -c)
	  if [ "$blcheck" == 0 ]; then
	    download_package
	    echo -e
	    foundmatch=1
	  else
	    echo -e "$PackageName => $TrueUpdateName [${C_Warning}Blacklisted${C_End}] [${C_Warning}Not Downloaded${C_End}]"
	  fi
        elif [ "$Verbose" ==  1 ]; then
          echo -e -n "$PackageName = $TrueUpdateName [${C_Ok}Up2Date${C_End}]"
	  echo -e
        fi
      fi
    
      unum=$((unum+1))
    done
    pnum=$((pnum+1))
  done
  if [ "$Color" == 1 ]; then
    echo -e "\\033[2K"
  else
    echo -e
  fi
}

# Check command line options
parse_options() {
  ExpectTemp=0
  ExpectLevel=0
  ExpectOutput=0
  ExpectServer=0
  ExpectVersion=0
  for OPTION in $OPTIONS; do
    case $OPTION in
    	-h)	echo -e "$HELP"
		exit_failure
		;;
    	-help)	echo -e "$HELP"
		exit_failure
		;;
    	--help)	echo -e "$HELP"
		exit_failure
		;;
    	-\?)	echo -e "$HELP"
		exit_failure
		;;
	-l)	ExpectLevel=1
		;;
	-o)	ExpectOutput=1
		;;
	-nc)	Color=0
		;;
	-np)	Passiv=0
		;;
	-pr)	Proz=1
		;;
	-r)	Retry=1
		;;
	-s)	ExpectServer=1
		;;
	-t)	ExpectTemp=1
		;;
	-u)	Patches="slackware"
	        SVersion="slackware-current"
		ExpectVersion=1
		;;
	-v)	Verbose=1
		;;
	*)	if [ "$ExpectTemp" == "1" ]; then
		  TEMPDIR="$OPTION"
		  ExpectTemp=0
		elif [ "$ExpectOutput" == "1" ]; then
		  OUTPUTDIR="$OPTION"
		  ExpectOutput=0
		elif [ "$ExpectLevel" == "1" ]; then
		  RunLevel="$OPTION"
		  ExpectLevel=0
		elif [ "$ExpectServer" == "1" ]; then
		  ServerP="$OPTION"
		  ExpectServer=0
		elif [ "$ExpectVersion" == "1" ]; then
		  SVersion="$OPTION"
		  ExpectVersion=0		
		else
		  echo -e "$HELP"
		  FAILURE="Incorrect command line parameters."
		  exit_failure
		fi
		;;
    esac
  done
}

# Verify that a correct runlevel has been specified
runlevel_check() {
  echo -e -n "Entering RunLevel: $RunLevel "
  if [ "$RunLevel" == 2 ]; then
    echo -e "[Automatically Install Updates]"
    if [ "$EUID" != "0" ]; then
      FAILURE="You must have root privileges to update system."
      exit_failure
    fi
  elif [ "$RunLevel" == 1 ]; then
    echo -e "[Check for and Download Updates]"
  elif [ "$RunLevel" == 0 ]; then
    echo -e "[Only Check for Updates]"
  else
    echo -e "[Unknown]"
    FAILURE="RunLevel Set incorrectly.  Please check Config."
    exit_failure
  fi
}

# Find a server
server_check() {
  echo -e -n "Checking for a Server"
  Servers="$ServerP $Server1 $Server2 $Server3"
  for TServer in $Servers; do
    if [ ! -r $TEMPDIR/CHECKSUMS.md5 ]; then
      echo -e -n "."
      Target="$TServer/$SVersion/$Patches/CHECKSUMS.md5"
      download
      Target="$TServer/$SVersion/$Patches/CHECKSUMS.md5.asc"
      download
      Server=$TServer/$SVersion
      ServerOld=$TServer/$SVersionOld
    fi
  done
  if [ ! -r $TEMPDIR/CHECKSUMS.md5 ]; then
    echo -e "[${C_Error}Failed${C_End}]"
    FAILURE="No upgrades found or no servers available."
    exit_failure
  else 
    echo -e "[${C_Info}Done${C_End}]"
    if [ "$Use_GPG" == 1 ]; then
      echo -e "Using GPG to verify files"
      gpgv CHECKSUMS.md5.asc CHECKSUMS.md5 1> /dev/null 2> /dev/null
      if [ $? != 0 ]; then
        FAILURE="MD5SUMS.md5 has incorrect GPG signature"
        exit_failure
      else
        echo -e "Using ${C_Info}$Server${C_End}"
      fi
    else
      echo -e "Using MD5 to verify files"
    fi
  fi
}

# Verify this system's version of Slackware
system_version_check() {
  echo -e -n "Checking Version..."
  if [ -r /etc/slackware-version ]; then
    Version1=`cat /etc/slackware-version | cut -d" " -f1 | tr 'A-Z' 'a-z'`
    Version2=`cat /etc/slackware-version | cut -d" " -f2 | cut -d. -f1,2`
    SVersionOld="$Version1-$Version2"
  else
    echo -e
    FAILURE="Could not find /etc/slackware-version.  This system is probably not slackware."
    exit_failure
  fi
  
  if [ "$Patches" != "slackware" ]; then
    SVersion=$SVersionOld
  elif [ "$SVersionOld" == "slackware-current" ]; then
    Patches="slackware"
    SVersionOld="slackware-10.1"
  elif [ "$SVersion" == "slackware-current" ]; then
    Patches="slackware"
  fi
  echo -e "[${C_Info}$SVersion${C_End}]"
}

# Create packages that didn't exist in your previous version of slackware
upgrade_changes() {
  cp CHECKSUMS.md5 CHECKSUMS-upgrade.md5
  rm CHECKSUMS.md5
  Target="$ServerOld/$Patches/CHECKSUMS.md5"
  download
  cp CHECKSUMS.md5 CHECKSUMS-old.md5
  rm CHECKSUMS.md5  
  cp CHECKSUMS-upgrade.md5 CHECKSUMS.md5

  cat CHECKSUMS-upgrade.md5 | grep "tgz$" | sed -e "s/.*\///" | cut -d/ -f2  | sed -e "s/-[^\-]*$//" | sed -e "s/-[^\-]*$//" | sed -e "s/-[^\-]*$//" | sort > UpgradeList.md5
  cat CHECKSUMS-old.md5 | grep "tgz$" | sed -e "s/.*\///" | cut -d/ -f2 | sed -e "s/-[^\-]*$//" | sed -e "s/-[^\-]*$//" | sed -e "s/-[^\-]*$//" | sort > OldList.md5
  PotentialAddList=`diff OldList.md5 UpgradeList.md5 | grep ">" | cut -d\  -f2`
  PotentialDelList=`diff OldList.md5 UpgradeList.md5 | grep "<" | cut -d\  -f2`

  for CheckItem in $PotentialAddList; do
    found=0
    if [ ! -z "`cat UpgradeList.md5 | grep ${CheckItem}`" ]; then
      if [ -z "`cat $BlackList | grep ${CheckItem}`" ]; then
        AddList="${AddList} ${CheckItem}"
      fi
    fi
  done
  for CheckItem in $PotentialDelList; do
    found=0
    if [ -z "`cat UpgradeList.md5 | grep ${CheckItem}`" ]; then
      if [ -z "`cat $BlackList | grep ${CheckItem}`" ]; then
        DelList="${DelList} ${CheckItem}"
      fi
    fi
  done
  
    
  if [ ${EUID} == 0 ]; then
    if [ ${RunLevel} == 2 ]; then
      for NewUpgradePkg in $AddList; do
        if [ -z "`ls /var/log/packages/$NewUpgradePkg-* 2> /dev/null`" ]; then
  	  echo -e "$UPakcage" > /var/log/packages/$NewUpgradePkg-0.0.0-i386-1
        fi      
      done
      echo -e "You may want to remove the following packages as they are outdated:"
      for NewUpgradePkg in $DelList; do
        deltest=`ls /var/log/packages/$NewUpgradePkg-* 2> /dev/null`
        if [ ! -z "${deltest}" ]; then
	  echo -e " - ${C_Warning}${deltest}${C_End}"
        fi
      done
    else
      echo -e
      echo -e "RunLevel 2 would have created the following files for packages that do not exist:"
      for NewUpgradePkg in $AddList; do
        if [ -z "`ls /var/log/packages/$NewUpgradePkg-* 2> /dev/null`" ]; then
	  echo -e " - ${C_Warning}/var/log/packages/$NewUpgradePkg-0.0.0-i386-1${C_End}"
        fi
      done
      echo -e
      echo -e "You may want to remove the following packages as they are outdated:"
      for NewUpgradePkg in $DelList; do
        deltest=`ls /var/log/packages/$NewUpgradePkg-* 2> /dev/null`
        if [ ! -z "${deltest}" ]; then
	  echo -e " - ${C_Warning}${deltest}${C_End}"
        fi
      done
    fi
  else
    echo -e
    echo -e "You do not have permission to modify /var/log/packages."
    echo -e "Please create the following files if packages for them do not exist:"
    for NewUpgradePkg in $AddList; do
      if [ -z "`ls /var/log/packages/$NewUpgradePkg-* 2> /dev/null`" ]; then
	echo -e " - ${C_Warning}/var/log/packages/$NewUpgradePkg-0.0.0-i386-1${C_End}"
      fi
    done
    echo -e
    echo -e "You do not have permission to modify /var/log/packages."
    echo -e "You may want to remove the following packages as they are outdated:"
    for NewUpgradePkg in $DelList; do
      deltest=`ls /var/log/packages/$NewUpgradePkg-* 2> /dev/null`
      if [ ! -z "${deltest}" ]; then
	echo -e " - ${C_Warning}${deltest}${C_End}"
      fi
    done

  fi
}

###########
# Program #
###########
echo -e
echo -e "Welcome to $VERSION"
check_for_commands
check_for_gpg
OPTIONS="$@"
parse_options
check_for_color
echo -e "Initializing..."
downloader_check
runlevel_check
init_dirs
check_for_new_version
system_version_check
server_check
match_packages
install_updates
look_for_new_files
echo -e
echo -e "Done"
echo -e "${C_End}"
