#!/usr/bin/env python
"""
   Example usage of PyTalpa.
   Here I'm showing jst the override for OnOpen, but you can 
   intercept OnClose or OnExec as well (same method parameters).

   bifferos@yahoo.co.uk
"""
import pytalpa,os

def Modified(f) :
  "Returns True if the file is being opened for modification."
  if (f & os.O_RDWR) :
    return True
  if (f & os.O_WRONLY) :
    return True
  return False


class VC(pytalpa.talpa) :
  """
     Simple vetting client that blocks the on-open event.
  """
  def OnOpen(self, path, pid, flags, mode) :
    if Modified(flags) :
      # Find if the path existed before
      if path.endswith("/SomeUniqueName.txt") :
        if os.path.exists(path) :
          print "File exists, and will not be modified"
          return 1   # TALPA_BLOCK
      print "Path:",path
      print "PID:",pid
      print "mode: %x"%mode
    return 0   # TALPA_ALLOW


# Create the vetting object.
d = VC()

# Endless loop
d.Vet(0)

