config() {
  NEW="$1"
  OLD="`dirname $NEW`/`basename $NEW .new`"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "`cat $OLD | md5sum`" = "`cat $NEW | md5sum`" ]; then # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}

COURIER_USERNAME=courier
COURIER_GROUPNAME=courier

config etc/courier/maildrop/quotawarnmsg.example.new
config etc/courier/maildrop/maildroprc.new

if ! grep -q $COURIER_USERNAME /etc/group; then
    groupadd $COURIER_USERNAME
fi

if ! grep -q $COURIER_GROUPNAME /etc/passwd; then
    useradd -g $COURIER_GROUPNAME -c "The virtual mail user" -d /home/vmail -s /bin/false $COURIER_USERNAME
fi


chmod 700 /etc/courier/
chown $COURIER_USERNAME:$COURIER_GROUPNAME /etc/courier

chmod 700 /etc/courier/maildrop
chown $COURIER_USERNAME:$COURIER_GROUPNAME /etc/courier/maildrop

chmod 640 /etc/courier/maildrop/*
chown $COURIER_USERNAME:$COURIER_GROUPNAME /etc/courier/maildrop/*

( cd usr/lib ; rm -rf librfc2045.so )
( cd usr/lib ; ln -sf librfc2045.so.0.0.0 librfc2045.so )
( cd usr/lib ; rm -rf librfc822.so )
( cd usr/lib ; ln -sf librfc822.so.0.0.0 librfc822.so )
( cd usr/lib ; rm -rf librfc822.so.0 )
( cd usr/lib ; ln -sf librfc822.so.0.0.0 librfc822.so.0 )
( cd usr/lib ; rm -rf librfc2045.so.0 )
( cd usr/lib ; ln -sf librfc2045.so.0.0.0 librfc2045.so.0 )
