/**
 * decode.c - mike example file
 * build: $ gcc decode.c -o decode -lmike
 *
 * @author Marek Behun <behun@webconsult.sk>
 * @license GNU/GPL - read the COPYING file
 *
 * $Id: decode.c,v 1.0.3 2006/09/19 18:04:57 mb Exp $
 */

#include <errno.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <unistd.h>
#include <mike.h>

// we need it
int filesize (uchar *fname) {
	struct stat attr;

	stat(fname, &attr);
	return attr.st_size;
}

int main (int argc, char *argv[]) {
	int end = 0, ex, size;
	uchar *data, *ret;
	FILE *fp;

	// usage
	if (argc < 4) {
		printf("usage: %s <fromfile> <tofile> <key>\n\n", argv[0]);
		exit(EXIT_FAILURE);
	}
	// we check the access of <fromfile>
	if (access(argv[1], R_OK) < 0) {
		printf("%s isn't readable!\n", argv[1]);
		end = 1;
	}
	// now we check the access of <tofile>
	ex = access(argv[2], F_OK);
	if ((ex == 0 && access(argv[2], W_OK) < 0) || (errno == ENOENT && access(dirname(argv[2]), W_OK) < 0)) {
		printf("%s isn't writable!\n", argv[2]);
		end = 1;
	}
	// we check the key
	if (argv[3] == "") {
		printf("you must enter key!\n");
		end = 1;
	}
	// if end == 1, program will exit
	if (end) {
		printf("\n");
		exit(EXIT_FAILURE);
	}
	// we get's the filesize of <fromfile>
	size = filesize(argv[1]);
	// now allocate memory
	data = malloc(size);
	// open <fromfile>, read data and close
	fp = fopen(argv[1], "r");
	fread(data, size, 1, fp);
	fclose(fp);
	// encode data to ret
	ret = mike_rawdecode(data, size, argv[3], strlen(argv[3]));
	// open <tofile>, write ret and close
	fp = fopen(argv[2], "w");
	fwrite(ret, size, 1, fp);
	fclose(fp);
	// exit
	printf("decoded...\n\n");
	exit(EXIT_SUCCESS);
}
