/**
 * mike.h - mike header file
 *
 * @author Marek Behun <behun@webconsult.sk>
 * @license GNU/GPL - read the COPYING file
 *
 * $Id: mike.h,v 1.0.7 2006/09/19 18:04:20 mb Exp $
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#ifdef uchar
#  undef uchar
#endif
#define uchar unsigned char

#define MIKE_MAJOR_VERSION 0
#define MIKE_MINOR_VERSION 1
#define MIKE_MICRO_VERSION 0
#define MIKE_VERSION "0.1.0"

uchar *mike_bin2hex (const uchar *str, int len);
uchar *mike_hex2bin (const uchar *str, int len);
uchar *mike_rawencode (const uchar *str, int slen, const uchar *key, int klen);
uchar *mike_rawdecode (const uchar *str, int slen, const uchar *key, int klen);
uchar *mike_encode (const uchar *str, int slen, const uchar *key, int klen, int *rlen, int *error);
uchar *mike_decode (const uchar *str, int slen, const uchar *key, int klen, int *rlen, int *error);
