#!/bin/bash
#
# Anyone got a better number to use? This should be high enough
# to avoid any conflicts.
#
if ! grep -q dialout /etc/group; then
	groupadd -g 666 dialout
fi

# fix "missing group" issue... which really wasn't missing ;-)
chown /bin/sliplogin root.dialout

touch bad
touch good
test -d /etc/slip || mkdir -p /etc/slip 
ln -sf /etc/slip/slip.login /etc/slip/new.slip.logout

for i in /etc/slip/new.* ; {
	j=`echo $i | cut -f2- -d"."`
	if [ -f /etc/slip/$j ]; then
	{
		echo "/etc/slip/$j" >> bad
	} else {
		mv $i /etc/slip/$j
		echo "/etc/slip/$j" >> good
	}
	fi
}
echo >> bad
echo >> good
echo "The following files were not updated:"
cat bad
echo "Please check the following files and edit as needed:"
cat good
cp good /root/SLIPLOGIN_FILES_TO_EDIT.txt
echo "A copy of this list has been placed into /root/SLIPLOGIN_FILES_TO_EDIT.txt"
rm bad
rm good
