config() {
  NEW="$1"
  OLD="`dirname $NEW`/`basename $NEW .new`"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "`cat $OLD | md5sum`" = "`cat $NEW | md5sum`" ]; then # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}

config etc/ssh/ssh_config.new
config etc/ssh/sshd_config.new

# If the sshd user/group don't exist, add them:
if grep "^sshd:x:" etc/passwd 1> /dev/null 2> /dev/null ; then
  true
else
  echo "sshd:x:33:33:sshd:/:" >> etc/passwd
fi
if grep "^sshd::" etc/group 1> /dev/null 2> /dev/null ; then
  true
else
  echo "sshd::33:sshd" >> etc/group
fi
if grep "^sshd:" etc/shadow 1> /dev/null 2> /dev/null ; then
  true
else
  echo "sshd:*:9797:0:::::" >> etc/shadow
fi
( cd usr/bin ; rm -rf slogin )
( cd usr/bin ; ln -sf ./ssh slogin )
( cd usr/man/man1 ; rm -rf slogin.1 )
( cd usr/man/man1 ; ln -sf ./ssh.1 slogin.1 )
