
/* This work is copyrighted. See COPYRIGHT.OLD & COPYRIGHT.NEW for   *
*  details. If they are missing then this copy is in violation of    *
*  the copyright conditions.                                        */

/*
**	lib_getstr.c
**
**	The routine wgetstr().
**
*/

#include "curses.priv.h"
#include "unctrl.h"

inline void backspace(WINDOW *win)
{
	mvwaddstr(curscr, win->_begy + win->_cury, win->_begx + win->_curx,
		 "\b \b");
	waddstr(win, "\b \b");
	fputs("\b \b", SP->_ofp);
	fflush(SP->_ofp);
	SP->_curscol--; 
}

int wgetstr(WINDOW *win, char *str)
{
bool	oldnl, oldecho, oldraw, oldcbreak, oldkeypad;
char	erasec;
char	killc;
char	*oldstr;
int ch;
  
#ifdef TRACE
	if (_tracing)
	    	_tracef("wgetstr(%x,%x) called", win, str);
#endif

	oldnl = SP->_nl;
	oldecho = SP->_echo;
	oldraw = SP->_raw;
	oldcbreak = SP->_cbreak;
	oldkeypad = win->_use_keypad;
	nl();
	noecho();
	noraw();
	cbreak();
	keypad(win, FALSE);

	erasec = erasechar();
	killc = killchar();

	oldstr = str;

	vidattr(win->_attrs);
	if (is_wintouched(win) || (win->_flags & _HASMOVED))
		wrefresh(win);

	while ((ch = wgetch(win)) != ERR) {
		if ((*str = (unsigned char)ch) == '\n')
			break;
	   	if (*str == erasec) {
			if (str > oldstr) {
		    		str--;
		    		backspace(win);
		    		if (*str < ' ' ||  *str == '\177')
					backspace(win);
			}
	 	} else if (*str == killc) {

			while (str > oldstr) {
			    	str--;
		    		backspace(win);
		    		if (*str < ' ' ||  *str == '\177')
					backspace(win);
			}
    	} else {
			mvwaddstr(curscr, win->_begy + win->_cury,
				  win->_begx + win->_curx, unctrl(*str));
			waddstr(win, unctrl(*str));
			fputs(unctrl(*str), SP->_ofp);
			fflush(SP->_ofp);
			SP->_curscol++;
			str++;
	   	}
	}

    win->_curx = 0;
    if (win->_cury < win->_maxy)
       win->_cury++;
	wrefresh(win);

	if (! oldnl)
	    nonl();

	if (oldecho)
	    echo();

	if (oldraw)
	    raw();

	if (! oldcbreak)
	    nocbreak();

	if (oldkeypad)
		keypad(win, TRUE);

	if (ch == ERR) {
		*str = '\0';
		return ERR;
	}
	*str = '\0';

#ifdef TRACE
	if (_tracing) {
	    _tracef("\twgetstr returns %s", oldstr);
	}
#endif

	return(OK);
}
